/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report;

import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.shaded.stagemonitor.configuration.converter.UrlValueConverter;
import java.net.URL;
import javax.annotation.Nullable;

public class ReporterConfiguration
extends ConfigurationOptionProvider {
    public static final String REPORTER_CATEGORY = "Reporter";
    private final ConfigurationOption<String> secretToken = ConfigurationOption.stringOption().key("secret_token").configurationCategory("Reporter").description("This string is used to ensure that only your agents can send data to your APM server.\n\nBoth the agents and the APM server have to be configured with the same secret token.Use if APM Server requires a token.").sensitive().build();
    private final ConfigurationOption<URL> serverUrl = ConfigurationOption.urlOption().key("server_url").configurationCategory("Reporter").label("The URL for your APM Server").description("The URL must be fully qualified, including protocol (http or https) and port.").dynamic(true).buildWithDefault(UrlValueConverter.INSTANCE.convert("http://localhost:8200"));
    private final ConfigurationOption<Integer> serverTimeout = ConfigurationOption.integerOption().key("server_timeout").configurationCategory("Reporter").label("A timeout in seconds.").description("If a request to the APM server takes longer than the configured timeout, the request is cancelled and the event (exception or transaction) is discarded. Set to None to disable timeouts.\n\nWARNING:  If timeouts are disabled or set to a high value, your app could experience memory issues if the APM server times out.").buildWithDefault(5);
    private final ConfigurationOption<Boolean> verifyServerCert = ConfigurationOption.booleanOption().key("verify_server_cert").configurationCategory("Reporter").description("By default, the agent verifies the SSL certificate if you use an HTTPS connection to the APM server.\n\nVerification can be disabled by changing this setting to false.").buildWithDefault(true);
    private final ConfigurationOption<Integer> flushInterval = ConfigurationOption.integerOption().key("flush_interval").configurationCategory("Reporter").description("Interval with which transactions should be sent to the APM server, in seconds.\n\nA lower value will increase the load on your APM server, while a higher value can increase the memory pressure on your app.\n\nA higher value also impacts the time until transactions are indexed and searchable in Elasticsearch.").buildWithDefault(1);
    private final ConfigurationOption<Integer> maxQueueSize = ConfigurationOption.integerOption().key("max_queue_size").configurationCategory("Reporter").description("Maximum queue length of transactions before sending transactions to the APM server.\n\nA lower value will increase the load on your APM server,while a higher value can increase the memory pressure of your app.\n\nA higher value also impacts the time until transactions are indexed and searchable in Elasticsearch.\n\nThis setting is useful to limit memory consumption if you experience a sudden spike of traffic.").dynamic(true).buildWithDefault(500);
    private final ConfigurationOption<Boolean> reportSynchronously = ConfigurationOption.booleanOption().key("report_sync").tags("internal").configurationCategory("Reporter").description("Only to be used for testing purposes. Blocks the requests until the transaction has been reported to the APM server.").buildWithDefault(false);
    private final ConfigurationOption<Boolean> includeProcessArguments = ConfigurationOption.booleanOption().key("include_process_args").configurationCategory("Reporter").description("Whether each transaction should have the process arguments attached.\nDisabled by default to save disk space.").buildWithDefault(false);

    @Nullable
    public String getSecretToken() {
        return this.secretToken.get();
    }

    public String getServerUrl() {
        return this.serverUrl.getValueAsString();
    }

    public int getServerTimeout() {
        return this.serverTimeout.get();
    }

    public boolean isVerifyServerCert() {
        return this.verifyServerCert.get();
    }

    public int getFlushInterval() {
        return this.flushInterval.get();
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize.get();
    }

    public boolean isReportSynchronously() {
        return this.reportSynchronously.get();
    }

    public boolean isIncludeProcessArguments() {
        return this.includeProcessArguments.get();
    }
}

