/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report;

import co.elastic.apm.configuration.CoreConfiguration;
import co.elastic.apm.impl.error.ErrorCapture;
import co.elastic.apm.impl.payload.ProcessInfo;
import co.elastic.apm.impl.payload.Service;
import co.elastic.apm.impl.payload.SystemInfo;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.report.PayloadSender;
import co.elastic.apm.report.Reporter;
import co.elastic.apm.report.ReporterConfiguration;
import co.elastic.apm.report.ReportingEvent;
import co.elastic.apm.report.ReportingEventHandler;
import co.elastic.apm.report.processor.ProcessorEventHandler;
import co.elastic.apm.shaded.lmax.disruptor.EventFactory;
import co.elastic.apm.shaded.lmax.disruptor.EventTranslator;
import co.elastic.apm.shaded.lmax.disruptor.EventTranslatorOneArg;
import co.elastic.apm.shaded.lmax.disruptor.PhasedBackoffWaitStrategy;
import co.elastic.apm.shaded.lmax.disruptor.WaitStrategy;
import co.elastic.apm.shaded.lmax.disruptor.dsl.Disruptor;
import co.elastic.apm.shaded.lmax.disruptor.dsl.ProducerType;
import co.elastic.apm.util.ExecutorUtils;
import co.elastic.apm.util.MathUtils;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class ApmServerReporter
implements Reporter {
    private static final EventTranslatorOneArg<ReportingEvent, Transaction> TRANSACTION_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Transaction>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, Transaction t) {
            event.setTransaction(t);
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, Span> SPAN_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, Span>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, Span s) {
            event.setSpan(s);
        }
    };
    private static final EventTranslator<ReportingEvent> FLUSH_EVENT_TRANSLATOR = new EventTranslator<ReportingEvent>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence) {
            event.setFlushEvent();
        }
    };
    private static final EventTranslatorOneArg<ReportingEvent, ErrorCapture> ERROR_EVENT_TRANSLATOR = new EventTranslatorOneArg<ReportingEvent, ErrorCapture>(){

        @Override
        public void translateTo(ReportingEvent event, long sequence, ErrorCapture error) {
            event.setError(error);
        }
    };
    private final Disruptor<ReportingEvent> disruptor;
    private final CoreConfiguration coreConfiguration;
    private final AtomicLong dropped = new AtomicLong();
    private final boolean dropTransactionIfQueueFull;
    private final ReportingEventHandler reportingEventHandler;
    private final boolean syncReport;
    private final PayloadSender payloadSender;
    @Nullable
    private ScheduledThreadPoolExecutor flushScheduler;

    public ApmServerReporter(Service service, ProcessInfo process, SystemInfo system, PayloadSender payloadSender, boolean dropTransactionIfQueueFull, ReporterConfiguration reporterConfiguration, ProcessorEventHandler processorEventHandler, CoreConfiguration coreConfiguration) {
        this.dropTransactionIfQueueFull = dropTransactionIfQueueFull;
        this.syncReport = reporterConfiguration.isReportSynchronously();
        this.payloadSender = payloadSender;
        this.disruptor = new Disruptor<ReportingEvent>(new TransactionEventFactory(), MathUtils.getNextPowerOf2(reporterConfiguration.getMaxQueueSize()), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("apm-reporter");
                return thread;
            }
        }, ProducerType.MULTI, (WaitStrategy)PhasedBackoffWaitStrategy.withLock(1L, 10L, TimeUnit.MILLISECONDS));
        this.coreConfiguration = coreConfiguration;
        this.reportingEventHandler = new ReportingEventHandler(service, process, system, payloadSender, reporterConfiguration, processorEventHandler);
        if (!reporterConfiguration.isIncludeProcessArguments()) {
            process.getArgv().clear();
        }
        this.disruptor.handleEventsWith(this.reportingEventHandler);
        this.disruptor.start();
        if (reporterConfiguration.getFlushInterval() > 0) {
            this.flushScheduler = ExecutorUtils.createSingleThreadSchedulingDeamonPool("elastic-apm-transaction-flusher", 1);
            this.flushScheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ApmServerReporter.this.disruptor.publishEvent(FLUSH_EVENT_TRANSLATOR);
                }
            }, reporterConfiguration.getFlushInterval(), reporterConfiguration.getFlushInterval(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void report(Transaction transaction) {
        if (!this.tryAddEventToRingBuffer(transaction, TRANSACTION_EVENT_TRANSLATOR)) {
            transaction.recycle();
        }
        if (this.syncReport) {
            this.waitForFlush();
        }
    }

    @Override
    public void report(Span span) {
        if (this.coreConfiguration.isDistributedTracingEnabled()) {
            if (!this.tryAddEventToRingBuffer(span, SPAN_EVENT_TRANSLATOR)) {
                span.recycle();
            }
            if (this.syncReport) {
                this.waitForFlush();
            }
        } else if (span.getTransaction() != null) {
            span.getTransaction().addSpan(span);
        }
    }

    private void waitForFlush() {
        try {
            this.flush().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getDropped() {
        return this.dropped.get() + this.payloadSender.getDropped();
    }

    @Override
    public long getReported() {
        return this.payloadSender.getReported();
    }

    @Override
    public Future<Void> flush() {
        this.disruptor.publishEvent(FLUSH_EVENT_TRANSLATOR);
        final long cursor = this.disruptor.getCursor();
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public Void get() throws InterruptedException {
                while (!ApmServerReporter.this.isEventProcessed(cursor)) {
                    Thread.sleep(1L);
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
                while (timeout > 0L && !ApmServerReporter.this.isEventProcessed(cursor)) {
                    Thread.sleep(1L);
                    --timeout;
                }
                if (!ApmServerReporter.this.isEventProcessed(cursor)) {
                    throw new TimeoutException();
                }
                return null;
            }
        };
    }

    private boolean isEventProcessed(long sequence) {
        return this.disruptor.getSequenceValueFor(this.reportingEventHandler) >= sequence;
    }

    @Override
    public void close() {
        this.disruptor.shutdown();
        if (this.flushScheduler != null) {
            this.flushScheduler.shutdown();
        }
    }

    @Override
    public void report(ErrorCapture error) {
        if (!this.tryAddEventToRingBuffer(error, ERROR_EVENT_TRANSLATOR)) {
            error.recycle();
        }
        if (this.syncReport) {
            this.waitForFlush();
        }
    }

    private <E extends Recyclable> boolean tryAddEventToRingBuffer(E event, EventTranslatorOneArg<ReportingEvent, E> eventTranslator) {
        if (this.dropTransactionIfQueueFull) {
            boolean queueFull;
            boolean bl = queueFull = !this.disruptor.getRingBuffer().tryPublishEvent(eventTranslator, event);
            if (queueFull) {
                this.dropped.incrementAndGet();
                return false;
            }
        } else {
            this.disruptor.getRingBuffer().publishEvent(eventTranslator, event);
        }
        return true;
    }

    static class TransactionEventFactory
    implements EventFactory<ReportingEvent> {
        TransactionEventFactory() {
        }

        @Override
        public ReportingEvent newInstance() {
            return new ReportingEvent();
        }
    }
}

