/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.report;

import co.elastic.apm.impl.error.ErrorPayload;
import co.elastic.apm.impl.payload.Agent;
import co.elastic.apm.impl.payload.Payload;
import co.elastic.apm.report.PayloadSender;
import co.elastic.apm.report.ReporterConfiguration;
import co.elastic.apm.report.serialize.PayloadSerializer;
import co.elastic.apm.shaded.okhttp3.MediaType;
import co.elastic.apm.shaded.okhttp3.OkHttpClient;
import co.elastic.apm.shaded.okhttp3.Request;
import co.elastic.apm.shaded.okhttp3.RequestBody;
import co.elastic.apm.shaded.okhttp3.Response;
import co.elastic.apm.shaded.okio.BufferedSink;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ApmServerHttpPayloadSender
implements PayloadSender {
    private static final Logger logger = LoggerFactory.getLogger(ApmServerHttpPayloadSender.class);
    private static final MediaType MEDIA_TYPE_JSON = Objects.requireNonNull(MediaType.parse("application/json"));
    private static final int GZIP_COMPRESSION_LEVEL = 3;
    private final OkHttpClient httpClient;
    private final ReporterConfiguration reporterConfiguration;
    private final PayloadSerializer payloadSerializer;
    private final ScheduledExecutorService healthCheckExecutorService;
    private long dropped = 0L;
    private long reported = 0L;

    public ApmServerHttpPayloadSender(OkHttpClient httpClient, PayloadSerializer payloadSerializer, ReporterConfiguration reporterConfiguration) {
        this.httpClient = httpClient;
        this.reporterConfiguration = reporterConfiguration;
        this.payloadSerializer = payloadSerializer;
        this.healthCheckExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("apm-server-healthcheck");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.healthCheckExecutorService.scheduleWithFixedDelay(new ApmServerHealthChecker(httpClient, reporterConfiguration), 0L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void sendPayload(final Payload payload) {
        logger.debug("Sending payload with {} elements to APM server {}", (Object)payload.getPayloadObjects().size(), (Object)this.reporterConfiguration.getServerUrl());
        String path = payload instanceof ErrorPayload ? "/v1/errors" : "/v1/transactions";
        Request.Builder builder = new Request.Builder().url(this.reporterConfiguration.getServerUrl() + path).header("User-Agent", this.getUserAgent(payload));
        if (this.reporterConfiguration.getSecretToken() != null) {
            builder.header("Authorization", "Bearer " + this.reporterConfiguration.getSecretToken());
        }
        if (this.useGzip(payload)) {
            builder.header("Content-Encoding", "deflate");
        }
        Request request = builder.post(new RequestBody(){

            @Override
            public MediaType contentType() {
                return MEDIA_TYPE_JSON;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                OutputStream os = sink.outputStream();
                if (ApmServerHttpPayloadSender.this.useGzip(payload)) {
                    Deflater def = new Deflater(3);
                    os = new DeflaterOutputStream(os, def);
                }
                try {
                    ApmServerHttpPayloadSender.this.payloadSerializer.serializePayload(os, payload);
                }
                finally {
                    os.close();
                    payload.recycle();
                }
            }
        }).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            int statusCode = response.code();
            logger.debug("APM server responded with status code {}", (Object)statusCode);
            if (statusCode >= 400) {
                this.dropped += (long)payload.getPayloadObjects().size();
                if (response.body() != null) {
                    logger.debug(response.body().string());
                }
            } else {
                this.reported += (long)payload.getPayloadObjects().size();
            }
            response.close();
        }
        catch (IOException e) {
            logger.debug("Sending payload to APM server failed", e);
            this.dropped += (long)payload.getPayloadObjects().size();
        }
    }

    private String getUserAgent(Payload payload) {
        Agent agent = payload.getService().getAgent();
        if (agent != null) {
            return "apm-agent-java " + agent.getVersion();
        }
        return "apm-agent-java";
    }

    private boolean useGzip(Payload payload) {
        return payload.getPayloadObjects().size() > 1;
    }

    @Override
    public long getDropped() {
        return this.dropped;
    }

    @Override
    public long getReported() {
        return this.reported;
    }

    private static class ApmServerHealthChecker
    implements Runnable {
        private final OkHttpClient httpClient;
        private final ReporterConfiguration reporterConfiguration;
        private final AtomicBoolean serverHealthy = new AtomicBoolean(true);

        ApmServerHealthChecker(OkHttpClient httpClient, ReporterConfiguration reporterConfiguration) {
            this.httpClient = httpClient;
            this.reporterConfiguration = reporterConfiguration;
        }

        @Override
        public void run() {
            boolean success;
            String message = null;
            try {
                int status = this.httpClient.newCall(new Request.Builder().url(this.reporterConfiguration.getServerUrl() + "/healthcheck").build()).execute().code();
                boolean bl = success = status == 200;
                if (!success) {
                    message = Integer.toString(status);
                }
            }
            catch (IOException e) {
                message = e.getMessage();
                success = false;
            }
            if (success) {
                if (!this.serverHealthy.getAndSet(true)) {
                    logger.info("Elastic APM server is available");
                }
            } else if (this.serverHealthy.getAndSet(false)) {
                logger.warn("Elastic APM server is not available ({})", (Object)message);
            }
        }
    }
}

