/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.plugin.api;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;

public class TransactionInstrumentation
extends ElasticApmInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public TransactionInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.TransactionImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public String getInstrumentationGroupName() {
        return "public-api";
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return true;
    }

    public static class EndInstrumentation
    extends TransactionInstrumentation {
        public EndInstrumentation() {
            super(ElementMatchers.named("end"));
        }

        @Advice.OnMethodEnter
        public static void end(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) Transaction transaction) {
            transaction.end();
        }
    }

    public static class SetUserInstrumentation
    extends TransactionInstrumentation {
        public SetUserInstrumentation() {
            super(ElementMatchers.named("setUser"));
        }

        @Advice.OnMethodEnter
        public static void setUser(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) Transaction transaction, @Advice.Argument(value=0) String id, @Advice.Argument(value=1) String email, @Advice.Argument(value=2) String username) {
            transaction.setUser(id, email, username);
        }
    }

    public static class AddTagInstrumentation
    extends TransactionInstrumentation {
        public AddTagInstrumentation() {
            super(ElementMatchers.named("addTag"));
        }

        @Advice.OnMethodEnter
        public static void addTag(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) Transaction transaction, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) String value) {
            transaction.addTag(key, value);
        }
    }

    public static class SetTypeInstrumentation
    extends TransactionInstrumentation {
        public SetTypeInstrumentation() {
            super(ElementMatchers.named("setType"));
        }

        @Advice.OnMethodEnter
        public static void setType(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) Transaction transaction, @Advice.Argument(value=0) String type) {
            transaction.setType(type);
        }
    }

    public static class SetNameInstrumentation
    extends TransactionInstrumentation {
        public SetNameInstrumentation() {
            super(ElementMatchers.named("setName"));
        }

        @Advice.OnMethodEnter
        public static void setName(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) Transaction transaction, @Advice.Argument(value=0) String name) {
            transaction.setName(name);
        }
    }
}

