/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.plugin.api;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;

public class SpanInstrumentation
extends ElasticApmInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public SpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.SpanImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return true;
    }

    @Override
    public String getInstrumentationGroupName() {
        return "public-api";
    }

    public static class EndInstrumentation
    extends SpanInstrumentation {
        public EndInstrumentation() {
            super(ElementMatchers.named("end"));
        }

        @Advice.OnMethodEnter
        public static void end(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Span span) {
            span.end();
        }
    }

    public static class SetTypeInstrumentation
    extends SpanInstrumentation {
        public SetTypeInstrumentation() {
            super(ElementMatchers.named("setType"));
        }

        @Advice.OnMethodEnter
        public static void setType(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Span span, @Advice.Argument(value=0) String type) {
            span.setType(type);
        }
    }

    public static class SetNameInstrumentation
    extends SpanInstrumentation {
        public SetNameInstrumentation() {
            super(ElementMatchers.named("setName"));
        }

        @Advice.OnMethodEnter
        public static void setName(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Span span, @Advice.Argument(value=0) String name) {
            span.setName(name);
        }
    }
}

