/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.plugin.api;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;

public class ElasticApmApiInstrumentation
extends ElasticApmInstrumentation {
    static final String PUBLIC_API_INSTRUMENTATION_GROUP = "public-api";
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    ElasticApmApiInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.ElasticApm");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return true;
    }

    @Override
    public String getInstrumentationGroupName() {
        return PUBLIC_API_INSTRUMENTATION_GROUP;
    }

    public static class CaptureExceptionInstrumentation
    extends ElasticApmApiInstrumentation {
        public CaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException"));
        }

        @Advice.OnMethodEnter
        private static void captureException(@Advice.Argument(value=0) @Nullable Exception e) {
            if (tracer != null) {
                tracer.captureException(e);
            }
        }
    }

    public static class CurrentSpanInstrumentation
    extends ElasticApmApiInstrumentation {
        public CurrentSpanInstrumentation() {
            super(ElementMatchers.named("doGetCurrentSpan"));
        }

        @Advice.OnMethodExit
        private static void doGetCurrentSpan(@Advice.Return(readOnly=false) Object span) {
            if (tracer != null) {
                span = tracer.currentSpan();
            }
        }
    }

    public static class StartSpanInstrumentation
    extends ElasticApmApiInstrumentation {
        public StartSpanInstrumentation() {
            super(ElementMatchers.named("doStartSpan"));
        }

        @Advice.OnMethodExit
        private static void doStartSpan(@Advice.Return(readOnly=false) Object span) {
            if (tracer != null) {
                span = tracer.startSpan();
            }
        }
    }

    public static class CurrentTransactionInstrumentation
    extends ElasticApmApiInstrumentation {
        public CurrentTransactionInstrumentation() {
            super(ElementMatchers.named("doGetCurrentTransaction"));
        }

        @Advice.OnMethodExit
        private static void doGetCurrentTransaction(@Advice.Return(readOnly=false) Object transaction) {
            if (tracer != null) {
                transaction = tracer.currentTransaction();
            }
        }
    }

    public static class StartTransactionInstrumentation
    extends ElasticApmApiInstrumentation {
        public StartTransactionInstrumentation() {
            super(ElementMatchers.named("doStartTransaction"));
        }

        @Advice.OnMethodExit
        private static void doStartTransaction(@Advice.Return(readOnly=false) Object transaction) {
            if (tracer != null) {
                transaction = tracer.startTransaction();
            }
        }
    }
}

