/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.opentracing.impl;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;

public class ScopeManagerInstrumentation
extends ElasticApmInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ScopeManagerInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmScopeManager");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return true;
    }

    @Override
    public String getInstrumentationGroupName() {
        return "opentracing";
    }

    public static class CurrentSpanInstrumentation
    extends ScopeManagerInstrumentation {
        public CurrentSpanInstrumentation() {
            super(ElementMatchers.named("getCurrentSpan"));
        }

        @Advice.OnMethodExit
        public static void getCurrentSpan(@Advice.Return(readOnly=false) Object span) {
            if (tracer != null) {
                span = tracer.currentSpan();
            }
        }
    }

    public static class CurrentTransactionInstrumentation
    extends ScopeManagerInstrumentation {
        public CurrentTransactionInstrumentation() {
            super(ElementMatchers.named("getCurrentTransaction"));
        }

        @Advice.OnMethodExit
        public static void getCurrentTransaction(@Advice.Return(readOnly=false) Object transaction) {
            if (tracer != null) {
                transaction = tracer.currentTransaction();
            }
        }
    }

    public static class ActivateInstrumentation
    extends ScopeManagerInstrumentation {
        public ActivateInstrumentation() {
            super(ElementMatchers.named("doActivate"));
        }

        @Advice.OnMethodEnter(inline=false)
        public static void doActivate(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) @Nullable Transaction transaction, @Advice.Argument(value=1, typing=Assigner.Typing.DYNAMIC) @Nullable Span span) {
            if (tracer != null) {
                if (transaction != null) {
                    tracer.activate(transaction);
                } else if (span != null) {
                    tracer.activate(span);
                }
            }
        }
    }
}

