/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.opentracing.impl;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.web.ResultUtil;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class ApmSpanInstrumentation
extends ElasticApmInstrumentation {
    static final String OPENTRACING_INSTRUMENTATION_GROUP = "opentracing";
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ApmSpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmSpan");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return true;
    }

    @Override
    public String getInstrumentationGroupName() {
        return OPENTRACING_INSTRUMENTATION_GROUP;
    }

    public static class BaggageItemsInstrumentation
    extends ApmSpanInstrumentation {
        public BaggageItemsInstrumentation() {
            super(ElementMatchers.named("baggageItems"));
        }

        @Advice.OnMethodExit
        public static void baggageItems(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) @Nullable Transaction transaction, @Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) @Nullable Span span, @Advice.Return(readOnly=false) Iterable<Map.Entry<String, String>> baggage) {
            baggage = BaggageItemsInstrumentation.doGetBaggage(transaction, span);
        }

        public static Iterable<Map.Entry<String, String>> doGetBaggage(@Nullable Transaction transaction, @Nullable Span span) {
            String traceParentHeader = null;
            if (transaction != null) {
                traceParentHeader = transaction.getTraceContext().getOutgoingTraceParentHeader().toString();
            }
            if (span != null) {
                traceParentHeader = span.getTraceContext().getOutgoingTraceParentHeader().toString();
            }
            if (traceParentHeader != null) {
                return Collections.singletonMap("Elastic-Apm-Traceparent", traceParentHeader).entrySet();
            }
            return Collections.emptyList();
        }
    }

    public static class TagInstrumentation
    extends ApmSpanInstrumentation {
        public TagInstrumentation() {
            super(ElementMatchers.named("handleTag"));
        }

        @Advice.OnMethodEnter(inline=false)
        public static void handleTag(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) @Nullable Transaction transaction, @Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) @Nullable Span span, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) @Nullable Object value) {
            if (value == null) {
                return;
            }
            if (transaction != null) {
                TagInstrumentation.handleTransactionTag(transaction, key, value);
            } else if (span != null) {
                TagInstrumentation.handleSpanTag(span, key, value);
            }
        }

        private static void handleTransactionTag(Transaction transaction, String key, Object value) {
            if (!TagInstrumentation.handleSpecialTransactionTag(transaction, key, value)) {
                transaction.addTag(key, value.toString());
            }
        }

        private static void handleSpanTag(Span span, String key, Object value) {
            TagInstrumentation.handleSpecialSpanTag(span, key, value);
        }

        private static boolean handleSpecialTransactionTag(Transaction transaction, String key, Object value) {
            if ("type".equals(key)) {
                transaction.setType(value.toString());
                return true;
            }
            if ("result".equals(key)) {
                transaction.withResult(value.toString());
                return true;
            }
            if ("error".equals(key)) {
                if (transaction.getResult() == null && Boolean.FALSE.equals(value)) {
                    transaction.withResult("error");
                }
                return true;
            }
            if ("http.status_code".equals(key) && value instanceof Number) {
                transaction.getContext().getResponse().withStatusCode(((Number)value).intValue());
                if (transaction.getResult() == null) {
                    transaction.withResult(ResultUtil.getResultByHttpStatus(((Number)value).intValue()));
                }
                transaction.setType("request");
                return true;
            }
            if ("http.method".equals(key)) {
                transaction.getContext().getRequest().withMethod(value.toString());
                transaction.setType("request");
                return true;
            }
            if ("http.url".equals(key)) {
                transaction.getContext().getRequest().getUrl().appendToFull(value.toString());
                transaction.setType("request");
                return true;
            }
            if ("sampling.priority".equals(key)) {
                return true;
            }
            if ("user.id".equals(key)) {
                transaction.getContext().getUser().withId(value.toString());
                return true;
            }
            if ("user.email".equals(key)) {
                transaction.getContext().getUser().withEmail(value.toString());
                return true;
            }
            if ("user.username".equals(key)) {
                transaction.getContext().getUser().withUsername(value.toString());
                return true;
            }
            return false;
        }

        private static boolean handleSpecialSpanTag(Span span, String key, Object value) {
            if ("type".equals(key)) {
                span.setType(value.toString());
                return true;
            }
            if ("sampling.priority".equals(key)) {
                return true;
            }
            if ("db.type".equals(key)) {
                span.getContext().getDb().withType(value.toString());
                if (TagInstrumentation.isCache(value)) {
                    span.setType("cache");
                } else {
                    span.setType("db");
                }
                return true;
            }
            if ("db.instance".equals(key)) {
                span.getContext().getDb().withInstance(value.toString());
                return true;
            }
            if ("db.statement".equals(key)) {
                span.getContext().getDb().withStatement(value.toString());
                return true;
            }
            if ("span.kind".equals(key)) {
                if (span.getType() == null && ("producer".equals(value) || "client".equals(value))) {
                    span.setType("ext");
                }
                return true;
            }
            return false;
        }

        private static boolean isCache(Object dbType) {
            return "redis".equals(dbType);
        }
    }

    public static class CreateErrorInstrumentation
    extends ApmSpanInstrumentation {
        public CreateErrorInstrumentation() {
            super(ElementMatchers.named("createError"));
        }

        @Advice.OnMethodEnter(inline=false)
        public static void createError(@Advice.Argument(value=0) long epochTimestampMillis, @Advice.Argument(value=1) Map<String, ?> fields) {
            Object errorObject = fields.get("error.object");
            if (tracer != null && errorObject instanceof Exception) {
                tracer.captureException(epochTimestampMillis, (Exception)errorObject);
            }
        }
    }

    public static class SetOperationName
    extends ApmSpanInstrumentation {
        public SetOperationName() {
            super(ElementMatchers.named("setOperationName"));
        }

        @Advice.OnMethodEnter(inline=false)
        public static void setOperationName(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) @Nullable Transaction transaction, @Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) @Nullable Span span, @Advice.Argument(value=0) @Nullable String operationName) {
            if (transaction != null) {
                transaction.setName(operationName);
            } else if (span != null) {
                span.setName(operationName);
            }
        }
    }

    public static class FinishInstrumentation
    extends ApmSpanInstrumentation {
        public FinishInstrumentation() {
            super(ElementMatchers.named("finishInternal"));
        }

        @Advice.OnMethodEnter(inline=false)
        public static void finishInternal(@Advice.FieldValue(value="transaction", typing=Assigner.Typing.DYNAMIC) @Nullable Transaction transaction, @Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) @Nullable Span span, @Advice.Argument(value=0) long finishMicros) {
            if (transaction != null) {
                if (transaction.getType() == null) {
                    if (transaction.getContext().getRequest().hasContent()) {
                        transaction.withType("request");
                    } else {
                        transaction.withType("unknown");
                    }
                }
                transaction.end(finishMicros * 1000L, false);
            } else if (span != null) {
                if (span.getType() == null) {
                    span.withType("unknown");
                }
                span.end(finishMicros * 1000L, false);
            }
        }
    }
}

