/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.opentracing.impl;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.sampling.ConstantSampler;
import co.elastic.apm.impl.sampling.Sampler;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import java.util.Map;
import javax.annotation.Nullable;

public class ApmSpanBuilderInstrumentation
extends ElasticApmInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(ApmSpanBuilderInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ApmSpanBuilderInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    private static long getStartTime(long microseconds) {
        return microseconds >= 0L ? microseconds * 1000L : System.nanoTime();
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmSpanBuilder");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return true;
    }

    @Override
    public String getInstrumentationGroupName() {
        return "opentracing";
    }

    public static class CreateSpanInstrumentation
    extends ApmSpanBuilderInstrumentation {
        public CreateSpanInstrumentation() {
            super(ElementMatchers.named("createSpan"));
        }

        @Advice.OnMethodExit
        private static void createSpan(@Advice.FieldValue(value="parentTransaction", typing=Assigner.Typing.DYNAMIC) @Nullable Transaction parentTransaction, @Advice.FieldValue(value="parentSpan", typing=Assigner.Typing.DYNAMIC) @Nullable Span parentSpan, @Advice.FieldValue(value="microseconds") long microseconds, @Advice.Return(readOnly=false) Object span) {
            span = CreateSpanInstrumentation.doCreateSpan(parentTransaction, parentSpan, microseconds);
        }

        @Nullable
        public static Span doCreateSpan(@Nullable Transaction parentTransaction, @Nullable Span parentSpan, long microseconds) {
            if (tracer != null && parentTransaction != null) {
                Transaction transaction = CreateSpanInstrumentation.getTransaction(parentTransaction, parentSpan);
                return tracer.startManualSpan(transaction, parentSpan, ApmSpanBuilderInstrumentation.getStartTime(microseconds));
            }
            return null;
        }

        @Nullable
        private static Transaction getTransaction(@Nullable Transaction parentTransaction, @Nullable Span parentSpan) {
            if (parentTransaction != null) {
                return parentTransaction;
            }
            if (parentSpan != null) {
                return parentSpan.getTransaction();
            }
            return null;
        }
    }

    public static class CreateTransactionInstrumentation
    extends ApmSpanBuilderInstrumentation {
        public CreateTransactionInstrumentation() {
            super(ElementMatchers.named("createTransaction"));
        }

        @Advice.OnMethodExit
        public static void createTransaction(@Advice.FieldValue(value="parentTransaction", typing=Assigner.Typing.DYNAMIC) @Nullable Transaction parentTransaction, @Advice.FieldValue(value="tags") Map<String, Object> tags, @Advice.FieldValue(value="operationName") String operationName, @Advice.FieldValue(value="microseconds") long microseconds, @Advice.Argument(value=0) @Nullable Iterable<Map.Entry<String, String>> baggage, @Advice.Return(readOnly=false) Object transaction) {
            transaction = CreateTransactionInstrumentation.doCreateTransaction(parentTransaction, tags, operationName, microseconds, baggage);
        }

        @Nullable
        public static Transaction doCreateTransaction(@Nullable Transaction parentTransaction, Map<String, Object> tags, String operationName, long microseconds, @Nullable Iterable<Map.Entry<String, String>> baggage) {
            if (tracer != null && parentTransaction == null) {
                if ("client".equals(tags.get("span.kind"))) {
                    logger.info("Ignoring transaction '{}', as a span.kind client can never be a transaction. Consider creating a span for the whole request.", (Object)operationName);
                    return tracer.noopTransaction();
                }
                Object samplingPriority = tags.get("sampling.priority");
                Sampler sampler = samplingPriority instanceof Number ? ConstantSampler.of(((Number)samplingPriority).intValue() > 0) : tracer.getSampler();
                return tracer.startManualTransaction(CreateTransactionInstrumentation.getTraceContextHeader(baggage), sampler, ApmSpanBuilderInstrumentation.getStartTime(microseconds));
            }
            return null;
        }

        @Nullable
        public static String getTraceContextHeader(@Nullable Iterable<Map.Entry<String, String>> baggage) {
            if (baggage != null) {
                for (Map.Entry<String, String> entry : baggage) {
                    if (!entry.getKey().equalsIgnoreCase("Elastic-Apm-Traceparent")) continue;
                    return entry.getValue();
                }
            }
            return null;
        }
    }

    public static class StartApmSpanInstrumentation
    extends ApmSpanBuilderInstrumentation {
        public StartApmSpanInstrumentation() {
            super(ElementMatchers.named("startApmSpan"));
        }

        @Advice.OnMethodEnter
        private static void startApmSpan(@Advice.FieldValue(value="ignoreActiveSpan") boolean ignoreActiveSpan, @Advice.FieldValue(value="parentTransaction", readOnly=false) @Nullable Object parentTransaction, @Advice.FieldValue(value="parentSpan", readOnly=false) @Nullable Object parentSpan) {
            if (tracer != null && StartApmSpanInstrumentation.isActive(ignoreActiveSpan, parentTransaction, parentSpan)) {
                parentTransaction = tracer.currentTransaction();
                parentSpan = tracer.currentSpan();
            }
        }

        public static boolean isActive(boolean ignoreActiveSpan, @Nullable Object parentTransaction, @Nullable Object parentSpan) {
            return !ignoreActiveSpan && parentSpan == null && parentTransaction == null;
        }
    }
}

