/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.objectpool.impl;

import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.objectpool.RecyclableObjectFactory;
import co.elastic.apm.objectpool.impl.AbstractObjectPool;
import co.elastic.apm.shaded.lmax.disruptor.EventFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import javax.annotation.Nullable;

public class QueueBasedObjectPool<T extends Recyclable>
extends AbstractObjectPool<T>
implements Collection<T> {
    private final Queue<T> queue;

    public QueueBasedObjectPool(Queue<T> queue, boolean preAllocate, RecyclableObjectFactory<T> recyclableObjectFactory) {
        super(recyclableObjectFactory);
        this.queue = queue;
        if (preAllocate) {
            for (int i = 0; i < this.queue.size(); ++i) {
                this.queue.offer(recyclableObjectFactory.createInstance());
            }
        }
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        return (T)((Recyclable)this.queue.poll());
    }

    @Override
    public void recycle(T obj) {
        obj.resetState();
        this.queue.offer(obj);
    }

    @Override
    public int getObjectsInPool() {
        return this.queue.size();
    }

    @Override
    public void close() {
    }

    @Override
    public int getSize() {
        return this.queue.size();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.queue.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    private static class PooledObjectEventFactory<T>
    implements EventFactory<PooledObjectHolder<T>> {
        private PooledObjectEventFactory() {
        }

        @Override
        public PooledObjectHolder<T> newInstance() {
            return new PooledObjectHolder();
        }
    }

    private static class PooledObjectHolder<T> {
        @Nullable
        T value;

        private PooledObjectHolder() {
        }

        public void set(T value) {
            this.value = value;
        }
    }
}

