/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.objectpool.impl;

import co.elastic.apm.objectpool.ObjectPool;
import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.objectpool.RecyclableObjectFactory;
import co.elastic.apm.objectpool.impl.AbstractObjectPool;
import java.io.IOException;
import javax.annotation.Nullable;

public class MixedObjectPool<T extends Recyclable>
extends AbstractObjectPool<T> {
    private final ObjectPool<T> primaryPool;
    private final ObjectPool<T> secondaryPool;

    public MixedObjectPool(RecyclableObjectFactory<T> recyclableObjectFactory, ObjectPool<T> primaryPool, ObjectPool<T> secondaryPool) {
        super(recyclableObjectFactory);
        this.primaryPool = primaryPool;
        this.secondaryPool = secondaryPool;
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        T recyclable = this.primaryPool.tryCreateInstance();
        if (recyclable == null) {
            this.secondaryPool.fillFromOtherPool(this.primaryPool, this.primaryPool.getSize());
            return this.primaryPool.tryCreateInstance();
        }
        return recyclable;
    }

    @Override
    public void recycle(T obj) {
        this.secondaryPool.recycle(obj);
    }

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public int getObjectsInPool() {
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.primaryPool.close();
        this.secondaryPool.close();
    }
}

