/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.objectpool.impl;

import co.elastic.apm.objectpool.ObjectPool;
import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.objectpool.RecyclableObjectFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractObjectPool<T extends Recyclable>
implements ObjectPool<T> {
    protected final RecyclableObjectFactory<T> recyclableObjectFactory;
    private final AtomicInteger garbageCreated = new AtomicInteger();

    protected AbstractObjectPool(RecyclableObjectFactory<T> recyclableObjectFactory) {
        this.recyclableObjectFactory = recyclableObjectFactory;
    }

    @Override
    public T createInstance() {
        Object recyclable = this.tryCreateInstance();
        if (recyclable == null) {
            this.garbageCreated.incrementAndGet();
            return this.recyclableObjectFactory.createInstance();
        }
        return recyclable;
    }

    @Override
    public void fillFromOtherPool(ObjectPool<T> otherPool, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            Object obj = this.tryCreateInstance();
            if (obj == null) {
                return;
            }
            otherPool.recycle(obj);
        }
    }

    @Override
    public long getGarbageCreated() {
        return this.garbageCreated.longValue();
    }
}

