/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.matcher;

import java.util.List;
import javax.annotation.Nullable;

public class WildcardMatcher {
    private static final String CASE_INSENSITIVE_PREFIX = "(?i)";
    private final String matcher;
    private final String stringRepresentation;
    private final boolean startsWith;
    private final boolean endsWith;
    private final boolean ignoreCase;

    private WildcardMatcher(String matcher, String stringRepresentation, boolean startsWith, boolean endsWith, boolean ignoreCase) {
        this.matcher = matcher;
        this.stringRepresentation = stringRepresentation;
        this.startsWith = startsWith;
        this.endsWith = endsWith;
        this.ignoreCase = ignoreCase;
    }

    public static WildcardMatcher valueOf(String wildcardString) {
        String matcher = wildcardString;
        boolean startsWith = false;
        boolean endsWith = false;
        boolean ignoreCase = false;
        if (matcher.startsWith(CASE_INSENSITIVE_PREFIX)) {
            ignoreCase = true;
            matcher = matcher.substring(CASE_INSENSITIVE_PREFIX.length(), matcher.length());
        }
        if (matcher.startsWith("*")) {
            endsWith = true;
            matcher = matcher.substring(1, matcher.length());
        }
        if (matcher.endsWith("*")) {
            startsWith = true;
            matcher = matcher.substring(0, matcher.length() - 1);
        }
        return new WildcardMatcher(matcher, wildcardString, startsWith, endsWith, ignoreCase);
    }

    private static boolean containsIgnoreCase(String src, String what) {
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyMatch(List<WildcardMatcher> matchers, String s) {
        return WildcardMatcher.anyMatch(matchers, s, null);
    }

    public static boolean anyMatch(List<WildcardMatcher> matchers, String firstPart, @Nullable String secondPart) {
        for (int i = 0; i < matchers.size(); ++i) {
            if (!matchers.get(i).matches(firstPart, secondPart)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public boolean matches(String s) {
        if (this.startsWith && this.endsWith) {
            return this.contains(s, this.matcher);
        }
        if (this.startsWith) {
            return this.startsWith(s, this.matcher);
        }
        if (this.endsWith) {
            return this.endsWith(s, this.matcher);
        }
        return this.equals(s, this.matcher);
    }

    public boolean matches(String firstPart, @Nullable String secondPart) {
        if (secondPart == null) {
            return this.matches(firstPart);
        }
        if (this.startsWith && this.endsWith) {
            return this.contains(firstPart, this.matcher) || this.contains(secondPart, this.matcher) || this.matches(firstPart.concat(secondPart));
        }
        if (this.startsWith) {
            if (firstPart.length() >= this.matcher.length()) {
                return this.startsWith(firstPart, this.matcher);
            }
            return this.startsWith(this.matcher, firstPart) && this.matches(firstPart.concat(secondPart));
        }
        if (this.endsWith) {
            if (secondPart.length() >= this.matcher.length()) {
                return this.endsWith(secondPart, this.matcher);
            }
            return this.endsWith(this.matcher, secondPart) && this.matches(firstPart.concat(secondPart));
        }
        return this.startsWith(this.matcher, firstPart) && this.endsWith(this.matcher, secondPart) && this.equals(firstPart.concat(secondPart), this.matcher);
    }

    private boolean startsWith(String s, String matcher) {
        return s.regionMatches(this.ignoreCase, 0, matcher, 0, matcher.length());
    }

    private boolean endsWith(String s, String matcher) {
        return s.regionMatches(this.ignoreCase, s.length() - matcher.length(), matcher, 0, matcher.length());
    }

    private boolean equals(String concat, String matcher) {
        return this.ignoreCase ? matcher.equalsIgnoreCase(concat) : matcher.equals(concat);
    }

    private boolean contains(String s, String matcher) {
        return this.ignoreCase ? WildcardMatcher.containsIgnoreCase(s, matcher) : s.contains(matcher);
    }
}

