/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.logging;

import co.elastic.apm.bci.ElasticApmAgent;
import co.elastic.apm.shaded.slf4j.event.Level;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.shaded.stagemonitor.configuration.source.ConfigurationSource;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoggingConfiguration
extends ConfigurationOptionProvider {
    private static final String SYSTEM_OUT = "System.out";
    private static final String LOG_LEVEL_KEY = "logging.log_level";
    private static final String LOG_FILE_KEY = "logging.log_file";
    private static final String DEFAULT_LOG_FILE = "System.out";
    private static final String LOGGING_CATEGORY = "Logging";
    private static final String AGENT_HOME_PLACEHOLDER = "_AGENT_HOME_";
    public ConfigurationOption<Level> logLevel = ConfigurationOption.enumOption(Level.class).key("logging.log_level").configurationCategory("Logging").description("Sets the logging level for the agent.").dynamic(true).addChangeListener(new ConfigurationOption.ChangeListener<Level>(){

        @Override
        public void onChange(ConfigurationOption<?> configurationOption, Level oldValue, Level newValue) {
            LoggingConfiguration.setLogLevel(newValue.toString());
        }
    }).buildWithDefault(Level.INFO);
    public ConfigurationOption<String> logFile = ConfigurationOption.stringOption().key("logging.log_file").configurationCategory("Logging").description("Sets the path of the agent logs.\nThe special value `_AGENT_HOME_` is a placeholder for the folder the elastic-apm-agent.jar is in.\nExample: `_AGENT_HOME_/logs/elastic-apm.log`\n\nWhen set to the special value 'System.out',\nthe logs are sent to standard out.\n\nNOTE: When logging to a file,\nit's content is deleted when the application starts.").dynamic(false).buildWithDefault("System.out");

    public static void init(List<ConfigurationSource> sources) {
        LoggingConfiguration.setLogLevel(LoggingConfiguration.getValue(LOG_LEVEL_KEY, sources, Level.INFO.toString()));
        LoggingConfiguration.setLogFileLocation(ElasticApmAgent.getAgentHome(), LoggingConfiguration.getValue(LOG_FILE_KEY, sources, "System.out"));
    }

    private static String getValue(String key, List<ConfigurationSource> sources, String defaultValue) {
        for (ConfigurationSource source : sources) {
            String value = source.getValue(key);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    private static void setLogLevel(@Nullable String level) {
        System.setProperty("co.elastic.apm.shaded.slf4j.simpleLogger.log.co.elastic.apm", level != null ? level : Level.INFO.toString());
        System.setProperty("co.elastic.apm.shaded.slf4j.simpleLogger.log.co.elastic.apm.shaded", Level.WARN.toString());
        System.setProperty("co.elastic.apm.shaded.slf4j.simpleLogger.showDateTime", Boolean.TRUE.toString());
        System.setProperty("co.elastic.apm.shaded.slf4j.simpleLogger.dateTimeFormat", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    private static void setLogFileLocation(@Nullable String agentHome, String logFile) {
        if ("System.out".equalsIgnoreCase(logFile)) {
            System.setProperty("co.elastic.apm.shaded.slf4j.simpleLogger.logFile", "System.out");
        } else {
            System.setProperty("co.elastic.apm.shaded.slf4j.simpleLogger.logFile", LoggingConfiguration.getActualLogFile(agentHome, logFile));
        }
    }

    @Nonnull
    private static String getActualLogFile(@Nullable String agentHome, String logFile) {
        File logDir;
        if (logFile.contains(AGENT_HOME_PLACEHOLDER)) {
            if (agentHome == null) {
                System.err.println("Could not resolve _AGENT_HOME_. Falling back to System.out.");
                return "System.out";
            }
            logFile = logFile.replace(AGENT_HOME_PLACEHOLDER, agentHome);
        }
        if (!(logDir = new File(logFile).getParentFile()).exists()) {
            logDir.mkdir();
        }
        if (!logDir.canWrite()) {
            System.err.println("Log file " + logFile + " is not writable. Falling back to System.out.");
            return "System.out";
        }
        System.out.println("Writing Elastic APM logs to " + logFile);
        return logFile;
    }
}

