/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.jdbc;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.jdbc.ConnectionInstrumentation;
import co.elastic.apm.jdbc.JdbcHelper;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class PreparedStatementInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    private static ElasticApmTracer tracer;
    @Nullable
    private static JdbcHelper jdbcEventListener;

    @Nullable
    @Advice.OnMethodEnter(inline=false)
    public static Span onBeforeExecute(@Advice.This PreparedStatement statement) throws SQLException {
        if (tracer != null && jdbcEventListener != null) {
            String sql = ConnectionInstrumentation.getSqlForStatement(statement);
            return jdbcEventListener.createJdbcSpan(sql, statement.getConnection(), tracer.currentSpan());
        }
        return null;
    }

    @Advice.OnMethodExit(inline=false, onThrowable=SQLException.class)
    public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown SQLException e) {
        if (span != null) {
            span.end();
        }
    }

    @Override
    public void init(ElasticApmTracer tracer) {
        PreparedStatementInstrumentation.tracer = tracer;
        jdbcEventListener = new JdbcHelper(tracer);
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.nameContains("Statement")).and(ElementMatchers.isSubTypeOf(PreparedStatement.class));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("execute").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArguments(0));
    }

    @Override
    public String getInstrumentationGroupName() {
        return "jdbc";
    }
}

