/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.jdbc;

import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

public class JdbcHelper {
    private static final Logger logger = LoggerFactory.getLogger(JdbcHelper.class);
    private static final Map<Connection, ConnectionMetaData> metaDataMap = Collections.synchronizedMap(new WeakHashMap());
    private final ElasticApmTracer elasticApmTracer;

    public JdbcHelper(ElasticApmTracer elasticApmTracer) {
        this.elasticApmTracer = elasticApmTracer;
    }

    @Nullable
    static String getMethod(@Nullable String sql) {
        if (sql == null) {
            return null;
        }
        if (sql.startsWith("SELECT") || sql.startsWith("select")) {
            return "SELECT";
        }
        int indexOfWhitespace = (sql = sql.trim()).indexOf(32);
        if (indexOfWhitespace > 0) {
            return sql.substring(0, indexOfWhitespace).toUpperCase();
        }
        return sql.toUpperCase();
    }

    private static boolean isAlreadyMonitored(@Nullable Span parent) {
        return parent != null && parent.getType() != null && parent.getType().startsWith("db.");
    }

    @Nullable
    Span createJdbcSpan(@Nullable String sql, Connection connection, @Nullable Span parentSpan) {
        if (sql == null || JdbcHelper.isAlreadyMonitored(parentSpan)) {
            return null;
        }
        Span span = this.elasticApmTracer.startSpan();
        if (span == null) {
            return null;
        }
        span.setName(JdbcHelper.getMethod(sql));
        span.setType("db.unknown.sql");
        try {
            ConnectionMetaData connectionMetaData = this.getConnectionMetaData(connection);
            span.setType(connectionMetaData.type);
            span.getContext().getDb().withUser(connectionMetaData.user).withStatement(sql).withType("sql");
        }
        catch (SQLException e) {
            logger.warn("Ignored exception", e);
        }
        return span;
    }

    private ConnectionMetaData getConnectionMetaData(Connection connection) throws SQLException {
        ConnectionMetaData connectionMetaData = metaDataMap.get(connection);
        if (connectionMetaData == null) {
            DatabaseMetaData metaData = connection.getMetaData();
            String dbVendor = this.getDbVendor(metaData.getURL());
            connectionMetaData = new ConnectionMetaData("db." + dbVendor + ".sql", metaData.getUserName());
            metaDataMap.put(connection, connectionMetaData);
        }
        return connectionMetaData;
    }

    String getDbVendor(String url) {
        String urlWithoutJdbc;
        int indexOfColonAfterVendor;
        int indexOfJdbc = url.indexOf("jdbc:") + 5;
        if (indexOfJdbc != -1 && (indexOfColonAfterVendor = (urlWithoutJdbc = url.substring(indexOfJdbc)).indexOf(":")) != -1) {
            return urlWithoutJdbc.substring(0, indexOfColonAfterVendor);
        }
        return "unknown";
    }

    private static class ConnectionMetaData {
        final String type;
        final String user;

        private ConnectionMetaData(String type, String user) {
            this.type = type;
            this.user = user;
        }
    }
}

