/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.jdbc;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

public class ConnectionInstrumentation
extends ElasticApmInstrumentation {
    static final String JDBC_INSTRUMENTATION_GROUP = "jdbc";
    private static final Map<PreparedStatement, String> statementSqlMap = Collections.synchronizedMap(new WeakHashMap());

    @Advice.OnMethodExit(inline=false)
    public static void storeSql(@Advice.Return PreparedStatement statement, @Advice.Argument(value=0) String sql) {
        statementSqlMap.put(statement, sql);
    }

    @Nullable
    static String getSqlForStatement(PreparedStatement statement) {
        String sql = statementSqlMap.get(statement);
        if (sql != null) {
            statementSqlMap.remove(statement);
        }
        return sql;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.nameContains("Connection")).and(ElementMatchers.isSubTypeOf(Connection.class));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("prepare").and(ElementMatchers.isPublic()).and(ElementMatchers.returns(ElementMatchers.isSubTypeOf(PreparedStatement.class))).and(ElementMatchers.takesArgument(0, String.class));
    }

    @Override
    public String getInstrumentationGroupName() {
        return JDBC_INSTRUMENTATION_GROUP;
    }
}

