/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.transaction;

import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.context.Context;
import co.elastic.apm.impl.sampling.Sampler;
import co.elastic.apm.impl.transaction.AbstractSpan;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.SpanCount;
import co.elastic.apm.impl.transaction.TransactionId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class Transaction
extends AbstractSpan
implements AutoCloseable {
    public static final String TYPE_REQUEST = "request";
    private final AtomicInteger spanIdCounter = new AtomicInteger();
    private final Context context = new Context();
    private final List<Span> spans = new ArrayList<Span>();
    private final Map<String, Object> marks = new HashMap<String, Object>();
    private final SpanCount spanCount = new SpanCount();
    private final TransactionId id = new TransactionId();
    @Nullable
    private transient ElasticApmTracer tracer;
    @Nullable
    private String result;
    @Nullable
    private String type;
    private boolean noop;

    public Transaction start(ElasticApmTracer tracer, @Nullable String traceParentHeader, long startTimestampNanos, Sampler sampler) {
        this.tracer = tracer;
        if (traceParentHeader != null) {
            this.traceContext.asChildOf(traceParentHeader);
        } else {
            this.traceContext.asRootSpan(sampler);
        }
        this.duration = startTimestampNanos;
        this.timestamp = System.currentTimeMillis();
        this.id.setToRandomValue();
        this.noop = false;
        return this;
    }

    public Transaction startNoop(ElasticApmTracer tracer) {
        this.name.append("noop");
        this.tracer = tracer;
        this.noop = true;
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getContextEnsureVisibility() {
        Transaction transaction = this;
        synchronized (transaction) {
            return this.context;
        }
    }

    public TransactionId getId() {
        return this.id;
    }

    public Transaction withName(@Nullable String name) {
        if (!this.isSampled()) {
            return this;
        }
        this.setName(name);
        return this;
    }

    @Nullable
    public String getResult() {
        return this.result;
    }

    public Transaction withResult(@Nullable String result) {
        if (!this.isSampled()) {
            return this;
        }
        this.result = result;
        return this;
    }

    @Deprecated
    public List<Span> getSpans() {
        return this.spans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Transaction addSpan(Span span) {
        if (!this.isSampled()) {
            return this;
        }
        Transaction transaction = this;
        synchronized (transaction) {
            this.spans.add(span);
        }
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        if (!this.isSampled()) {
            return;
        }
        this.type = type;
    }

    public void addTag(String key, String value) {
        if (!this.isSampled()) {
            return;
        }
        this.getContext().getTags().put(key, value);
    }

    public void setUser(String id, String email, String username) {
        if (!this.isSampled()) {
            return;
        }
        this.getContext().getUser().withId(id).withEmail(email).withUsername(username);
    }

    public void end() {
        this.end(System.nanoTime(), true);
    }

    public void end(long nanoTime, boolean releaseActiveTransaction) {
        this.duration = ((double)nanoTime - this.duration) / ElasticApmTracer.MS_IN_NANOS;
        if (!this.isSampled()) {
            this.context.resetState();
        }
        if (this.tracer != null) {
            this.tracer.endTransaction(this, releaseActiveTransaction);
        }
    }

    @Override
    public void close() {
        this.end();
    }

    public Transaction withType(@Nullable String type) {
        this.type = type;
        return this;
    }

    public Map<String, Object> getMarks() {
        return this.marks;
    }

    public SpanCount getSpanCount() {
        return this.spanCount;
    }

    int getNextSpanId() {
        return this.spanIdCounter.incrementAndGet();
    }

    @Override
    public void resetState() {
        super.resetState();
        this.context.resetState();
        this.id.resetState();
        this.result = null;
        this.spans.clear();
        this.type = null;
        this.marks.clear();
        this.spanCount.resetState();
        this.tracer = null;
        this.spanIdCounter.set(0);
        this.noop = false;
        this.traceContext.resetState();
    }

    public void recycle() {
        if (this.tracer != null) {
            this.tracer.recycle(this);
        }
    }

    public boolean isNoop() {
        return this.noop;
    }

    public String toString() {
        return String.format("'%s' %s", this.name, this.id);
    }
}

