/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.transaction;

import co.elastic.apm.impl.sampling.Sampler;
import co.elastic.apm.impl.transaction.SpanId;
import co.elastic.apm.impl.transaction.TraceId;
import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import co.elastic.apm.util.HexUtils;

public class TraceContext
implements Recyclable {
    public static final String TRACE_PARENT_HEADER = "Elastic-Apm-Traceparent";
    private static final Logger logger = LoggerFactory.getLogger(TraceContext.class);
    private static final int TRACE_PARENT_LENGTH = 55;
    private static final byte FLAG_SAMPLED = 1;
    private final TraceId traceId = new TraceId();
    private final SpanId id = new SpanId();
    private final SpanId parentId = new SpanId();
    private final StringBuilder outgoingHeader = new StringBuilder(55);
    private byte flags;

    public void asChildOf(String traceParentHeader) {
        if (traceParentHeader.length() != 55) {
            logger.warn("The traceparent header has to be exactly 55 chars long, but was '{}'", (Object)traceParentHeader);
            return;
        }
        if (!traceParentHeader.startsWith("00-")) {
            logger.warn("Only version 00 of the traceparent header is supported, but was '{}'", (Object)traceParentHeader);
            return;
        }
        this.parseTraceId(traceParentHeader);
        this.parseParentId(traceParentHeader);
        this.id.setToRandomValue();
        this.flags = this.getTraceOptions(traceParentHeader);
    }

    public void asRootSpan(Sampler sampler) {
        this.traceId.setToRandomValue();
        this.id.setToRandomValue();
        if (sampler.isSampled(this.traceId)) {
            this.flags = 1;
        }
    }

    public void asChildOf(TraceContext traceContext) {
        this.traceId.copyFrom(traceContext.traceId);
        this.parentId.copyFrom(traceContext.id);
        this.flags = traceContext.flags;
        this.id.setToRandomValue();
    }

    private void parseTraceId(String traceParent) {
        HexUtils.nextBytes(traceParent, 3, this.traceId.getBytes());
    }

    private void parseParentId(String traceParent) {
        HexUtils.nextBytes(traceParent, 36, this.parentId.getBytes());
    }

    private byte getTraceOptions(String traceParent) {
        return HexUtils.getNextByte(traceParent, 53);
    }

    @Override
    public void resetState() {
        this.traceId.resetState();
        this.id.resetState();
        this.parentId.resetState();
        this.outgoingHeader.setLength(0);
        this.flags = 0;
    }

    public TraceId getTraceId() {
        return this.traceId;
    }

    public SpanId getId() {
        return this.id;
    }

    public SpanId getParentId() {
        return this.parentId;
    }

    public boolean isSampled() {
        return (this.flags & 1) == 1;
    }

    public void setSampled(boolean sampled) {
        this.flags = sampled ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public String getIncomingTraceParentHeader() {
        StringBuilder sb = new StringBuilder(55);
        this.fillTraceParentHeader(sb, this.parentId);
        return sb.toString();
    }

    public StringBuilder getOutgoingTraceParentHeader() {
        if (this.outgoingHeader.length() == 0) {
            this.fillTraceParentHeader(this.outgoingHeader, this.id);
        }
        return this.outgoingHeader;
    }

    private void fillTraceParentHeader(StringBuilder sb, SpanId spanId) {
        sb.append("00-");
        HexUtils.writeBytesAsHex(this.traceId.getBytes(), sb);
        sb.append('-');
        HexUtils.writeBytesAsHex(spanId.getBytes(), sb);
        sb.append('-');
        HexUtils.writeByteAsHex(this.flags, sb);
    }

    public boolean isChildOf(TraceContext parent) {
        return parent.getTraceId().equals(this.traceId) && parent.getId().equals(this.parentId);
    }

    public boolean hasContent() {
        return !this.traceId.isEmpty() && this.parentId.asLong() != 0L && this.id.asLong() != 0L;
    }
}

