/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.transaction;

import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.util.HexUtils;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class SpanId
implements Recyclable {
    private static final int LENGTH = 8;
    private final byte[] data = new byte[8];

    public void setToRandomValue() {
        this.setToRandomValue(ThreadLocalRandom.current());
    }

    public void setToRandomValue(Random random) {
        random.nextBytes(this.data);
    }

    public void setLong(long l) {
        for (int i = 7; i >= 0; --i) {
            this.data[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    @Override
    public void resetState() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    public long asLong() {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(this.data[i] & 0xFF);
        }
        return l;
    }

    public void copyFrom(SpanId other) {
        System.arraycopy(other.data, 0, this.data, 0, 8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanId spanId = (SpanId)o;
        return Arrays.equals(this.data, spanId.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public byte[] getBytes() {
        return this.data;
    }

    public String toString() {
        return HexUtils.bytesToHex(this.data);
    }
}

