/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.transaction;

import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.stacktrace.Stacktrace;
import co.elastic.apm.impl.transaction.AbstractSpan;
import co.elastic.apm.impl.transaction.SpanContext;
import co.elastic.apm.impl.transaction.SpanId;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.objectpool.Recyclable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Span
extends AbstractSpan
implements Recyclable,
AutoCloseable {
    private final SpanContext context = new SpanContext();
    private final List<Stacktrace> stacktrace = new ArrayList<Stacktrace>();
    @Deprecated
    private final SpanId id = new SpanId();
    @Nullable
    private transient ElasticApmTracer tracer;
    @Deprecated
    private SpanId parent = new SpanId();
    private double start;
    @Nullable
    private String type;
    @Nullable
    private Transaction transaction;

    public Span start(ElasticApmTracer tracer, Transaction transaction, @Nullable Span parentSpan, long nanoTime, boolean dropped) {
        this.tracer = tracer;
        this.transaction = transaction;
        this.id.setLong(transaction.getNextSpanId());
        if (parentSpan != null) {
            this.parent.copyFrom(parentSpan.getId());
            this.traceContext.asChildOf(parentSpan.getTraceContext());
        } else {
            this.traceContext.asChildOf(transaction.getTraceContext());
        }
        if (dropped) {
            this.traceContext.setSampled(false);
        }
        if (this.traceContext.isSampled()) {
            this.start = ((double)nanoTime - transaction.getDuration()) / ElasticApmTracer.MS_IN_NANOS;
            this.duration = nanoTime;
            this.timestamp = System.currentTimeMillis();
        }
        return this;
    }

    @Deprecated
    public SpanId getId() {
        return this.id;
    }

    public SpanContext getContext() {
        return this.context;
    }

    public Span withName(@Nullable String name) {
        this.setName(name);
        return this;
    }

    @Deprecated
    public SpanId getParent() {
        return this.parent;
    }

    public List<Stacktrace> getStacktrace() {
        return this.stacktrace;
    }

    public double getStart() {
        return this.start;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.withType(type);
    }

    public void end() {
        this.end(System.nanoTime(), true);
    }

    public void end(long nanoTime, boolean releaseActiveSpan) {
        if (this.isSampled()) {
            this.duration = ((double)nanoTime - this.duration) / ElasticApmTracer.MS_IN_NANOS;
        }
        if (this.tracer != null) {
            this.tracer.endSpan(this, releaseActiveSpan);
        }
    }

    @Override
    public void close() {
        this.end();
    }

    public Span withType(@Nullable String type) {
        if (!this.isSampled()) {
            return this;
        }
        this.type = type;
        return this;
    }

    @Override
    public void resetState() {
        super.resetState();
        this.id.resetState();
        this.context.resetState();
        this.parent.resetState();
        this.stacktrace.clear();
        this.start = 0.0;
        this.type = null;
        this.tracer = null;
        this.transaction = null;
        this.traceContext.resetState();
    }

    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    public void recycle() {
        if (this.tracer != null) {
            this.tracer.recycle(this);
        }
    }

    public String toString() {
        return String.format("'%s' %s:%s", this.name, this.transaction != null ? this.transaction.getId() : null, this.id.asLong());
    }
}

