/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.transaction;

import co.elastic.apm.impl.transaction.TraceContext;
import co.elastic.apm.objectpool.Recyclable;
import javax.annotation.Nullable;

public abstract class AbstractSpan
implements Recyclable {
    protected final TraceContext traceContext = new TraceContext();
    protected final StringBuilder name = new StringBuilder();
    protected long timestamp;
    protected double duration;

    public double getDuration() {
        return this.duration;
    }

    public StringBuilder getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        if (!this.isSampled()) {
            return;
        }
        this.name.setLength(0);
        this.name.append(name);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isSampled() {
        return this.traceContext.isSampled();
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    @Override
    public void resetState() {
        this.name.setLength(0);
        this.timestamp = 0L;
        this.duration = 0.0;
    }

    public boolean isChildOf(AbstractSpan parent) {
        return this.traceContext.isChildOf(parent.traceContext);
    }
}

