/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.stacktrace;

import co.elastic.apm.impl.stacktrace.Stacktrace;
import co.elastic.apm.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.objectpool.NoopObjectPool;
import co.elastic.apm.objectpool.ObjectPool;
import co.elastic.apm.objectpool.RecyclableObjectFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public interface StacktraceFactory {
    public void fillStackTrace(List<Stacktrace> var1);

    public boolean isAvailable();

    public void fillStackTrace(List<Stacktrace> var1, StackTraceElement[] var2);

    public static class CurrentThreadStackTraceFactory
    implements StacktraceFactory {
        private final StacktraceConfiguration stacktraceConfiguration;
        private final Collection<String> excludedStackFrames = Arrays.asList("java.lang.reflect", "com.sun", "sun.", "jdk.internal.");
        private final ObjectPool<Stacktrace> stacktraceObjectPool;

        public CurrentThreadStackTraceFactory(StacktraceConfiguration stacktraceConfiguration) {
            this(stacktraceConfiguration, new NoopObjectPool<Stacktrace>(new RecyclableObjectFactory<Stacktrace>(){

                @Override
                public Stacktrace createInstance() {
                    return new Stacktrace();
                }
            }));
        }

        public CurrentThreadStackTraceFactory(StacktraceConfiguration stacktraceConfiguration, ObjectPool<Stacktrace> stacktraceObjectPool) {
            this.stacktraceConfiguration = stacktraceConfiguration;
            this.stacktraceObjectPool = stacktraceObjectPool;
        }

        @Override
        public void fillStackTrace(List<Stacktrace> stacktrace) {
            this.fillStackTrace(stacktrace, Thread.currentThread().getStackTrace());
        }

        @Override
        public void fillStackTrace(List<Stacktrace> stacktrace, StackTraceElement[] stackTrace) {
            boolean topMostElasticApmPackagesSkipped = false;
            int collectedStackFrames = 0;
            int stackTraceLimit = this.stacktraceConfiguration.getStackTraceLimit();
            for (int i = 1; i < stackTrace.length && collectedStackFrames < stackTraceLimit; ++i) {
                StackTraceElement stackTraceElement = stackTrace[i];
                if (!topMostElasticApmPackagesSkipped && stackTraceElement.getClassName().startsWith("co.elastic.apm")) continue;
                topMostElasticApmPackagesSkipped = true;
                if (this.isExcluded(stackTraceElement)) continue;
                stacktrace.add(this.getStacktrace(stackTraceElement));
                ++collectedStackFrames;
            }
        }

        private Stacktrace getStacktrace(StackTraceElement stackTraceElement) {
            Stacktrace s = this.stacktraceObjectPool.createInstance().withAbsPath(stackTraceElement.getClassName()).withFilename(stackTraceElement.getFileName()).withFunction(stackTraceElement.getMethodName()).withLineno(stackTraceElement.getLineNumber()).withLibraryFrame(true);
            for (String applicationPackage : this.stacktraceConfiguration.getApplicationPackages()) {
                if (!stackTraceElement.getClassName().startsWith(applicationPackage)) continue;
                s.withLibraryFrame(false);
            }
            return s;
        }

        private boolean isExcluded(StackTraceElement stackTraceElement) {
            if (stackTraceElement.getFileName() == null) {
                return true;
            }
            String className = stackTraceElement.getClassName();
            for (String excludedStackFrame : this.excludedStackFrames) {
                if (!className.startsWith(excludedStackFrame)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }
    }

    public static enum Noop implements StacktraceFactory
    {
        INSTANCE;


        @Override
        public void fillStackTrace(List<Stacktrace> stacktrace) {
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void fillStackTrace(List<Stacktrace> stacktrace, StackTraceElement[] stackTrace) {
        }
    }
}

