/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.sampling;

import co.elastic.apm.impl.sampling.ConstantSampler;
import co.elastic.apm.impl.sampling.Sampler;
import co.elastic.apm.impl.transaction.TraceId;

public class ProbabilitySampler
implements Sampler {
    private final long lowerBound;
    private final long higherBound;

    public static Sampler of(double samplingRate) {
        if (samplingRate == 1.0) {
            return ConstantSampler.of(true);
        }
        if (samplingRate == 0.0) {
            return ConstantSampler.of(false);
        }
        return new ProbabilitySampler(samplingRate);
    }

    private ProbabilitySampler(double samplingRate) {
        this.higherBound = (long)(9.223372036854776E18 * samplingRate);
        this.lowerBound = -this.higherBound;
    }

    @Override
    public boolean isSampled(TraceId traceId) {
        long mostSignificantBits = traceId.getMostSignificantBits();
        return mostSignificantBits > this.lowerBound && mostSignificantBits < this.higherBound;
    }
}

