/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.payload;

import co.elastic.apm.impl.payload.Payload;
import co.elastic.apm.impl.payload.ProcessInfo;
import co.elastic.apm.impl.payload.Service;
import co.elastic.apm.impl.payload.SystemInfo;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.objectpool.Recyclable;
import java.util.ArrayList;
import java.util.List;

public class TransactionPayload
extends Payload {
    private final List<Transaction> transactions = new ArrayList<Transaction>();
    private final List<Span> spans = new ArrayList<Span>();

    public TransactionPayload(ProcessInfo process, Service service, SystemInfo system) {
        super(process, service, system);
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public List<Span> getSpans() {
        return this.spans;
    }

    @Override
    public void resetState() {
        this.transactions.clear();
        this.spans.clear();
    }

    @Override
    public List<? extends Recyclable> getPayloadObjects() {
        return this.transactions;
    }

    @Override
    public void recycle() {
        int i;
        for (i = 0; i < this.transactions.size(); ++i) {
            this.transactions.get(i).recycle();
        }
        for (i = 0; i < this.spans.size(); ++i) {
            this.spans.get(i).recycle();
        }
    }
}

