/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.payload;

import java.net.InetAddress;

public class SystemInfo {
    private final String architecture;
    private final String hostname;
    private final String platform;

    public SystemInfo(String architecture, String hostname, String platform) {
        this.architecture = architecture;
        this.hostname = hostname;
        this.platform = platform;
    }

    public static SystemInfo create() {
        return new SystemInfo(System.getProperty("os.arch"), System.getProperty("os.name"), SystemInfo.getNameOfLocalHost());
    }

    private static String getNameOfLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return SystemInfo.getHostNameFromEnv();
        }
    }

    private static String getHostNameFromEnv() {
        String host = System.getenv("COMPUTERNAME");
        if (host == null) {
            host = System.getenv("HOSTNAME");
        }
        if (host == null) {
            host = System.getenv("HOST");
        }
        return host;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPlatform() {
        return this.platform;
    }
}

