/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.context;

import co.elastic.apm.objectpool.Recyclable;
import javax.annotation.Nullable;

public class Url
implements Recyclable {
    private final StringBuilder full = new StringBuilder();
    @Nullable
    private String protocol;
    @Nullable
    private String hostname;
    private final StringBuilder port = new StringBuilder();
    @Nullable
    private String pathname;
    @Nullable
    private String search;

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    public Url withProtocol(@Nullable String protocol) {
        this.protocol = protocol;
        return this;
    }

    public StringBuilder getFull() {
        return this.full;
    }

    public Url appendToFull(CharSequence charSequence) {
        this.full.append(charSequence);
        return this;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public Url withHostname(@Nullable String hostname) {
        this.hostname = hostname;
        return this;
    }

    public StringBuilder getPort() {
        return this.port;
    }

    public Url withPort(int port) {
        this.port.append(port);
        return this;
    }

    @Nullable
    public String getPathname() {
        return this.pathname;
    }

    public Url withPathname(@Nullable String pathname) {
        this.pathname = pathname;
        return this;
    }

    @Nullable
    public String getSearch() {
        return this.search;
    }

    public Url withSearch(@Nullable String search) {
        this.search = search;
        return this;
    }

    @Override
    public void resetState() {
        this.protocol = null;
        this.full.setLength(0);
        this.hostname = null;
        this.port.setLength(0);
        this.pathname = null;
        this.search = null;
    }

    public void copyFrom(Url other) {
        this.protocol = other.protocol;
        this.full.append((CharSequence)other.full);
        this.hostname = other.hostname;
        this.port.append((CharSequence)other.port);
        this.pathname = other.pathname;
        this.search = other.search;
    }

    public boolean hasContent() {
        return this.protocol != null || this.full.length() > 0 || this.hostname != null || this.port.length() > 0 || this.pathname != null || this.search != null;
    }
}

