/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl.context;

import co.elastic.apm.impl.context.Socket;
import co.elastic.apm.impl.context.Url;
import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.util.PotentiallyMultiValuedMap;
import javax.annotation.Nullable;

public class Request
implements Recyclable {
    private final PotentiallyMultiValuedMap postParams = new PotentiallyMultiValuedMap();
    private final PotentiallyMultiValuedMap headers = new PotentiallyMultiValuedMap();
    private final Socket socket = new Socket();
    private final Url url = new Url();
    private final PotentiallyMultiValuedMap cookies = new PotentiallyMultiValuedMap();
    @Nullable
    private String rawBody;
    @Nullable
    private String httpVersion;
    @Nullable
    private String method;

    @Nullable
    public Object getBody() {
        if (!this.postParams.isEmpty()) {
            return this.postParams;
        }
        return this.rawBody;
    }

    @Nullable
    public String getRawBody() {
        return this.rawBody;
    }

    public void redactBody() {
        this.postParams.resetState();
        this.rawBody = "[REDACTED]";
    }

    public Request addFormUrlEncodedParameter(String key, String value) {
        this.postParams.add(key, value);
        return this;
    }

    public Request addFormUrlEncodedParameters(String key, String[] values) {
        this.postParams.set(key, values);
        return this;
    }

    public Request withRawBody(String rawBody) {
        this.rawBody = rawBody;
        return this;
    }

    public PotentiallyMultiValuedMap getFormUrlEncodedParameters() {
        return this.postParams;
    }

    public Request addHeader(String headerName, @Nullable String headerValue) {
        if (headerValue != null) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    public PotentiallyMultiValuedMap getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getHttpVersion() {
        return this.httpVersion;
    }

    public Request withHttpVersion(@Nullable String httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public Request withMethod(@Nullable String method) {
        this.method = method;
        return this;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Url getUrl() {
        return this.url;
    }

    public Request addCookie(String cookieName, String cookieValue) {
        this.cookies.add(cookieName, cookieValue);
        return this;
    }

    public PotentiallyMultiValuedMap getCookies() {
        return this.cookies;
    }

    @Override
    public void resetState() {
        this.rawBody = null;
        this.postParams.resetState();
        this.headers.resetState();
        this.httpVersion = null;
        this.method = null;
        this.socket.resetState();
        this.url.resetState();
        this.cookies.resetState();
    }

    public void copyFrom(Request other) {
        this.rawBody = other.rawBody;
        this.postParams.copyFrom(other.postParams);
        this.headers.copyFrom(other.headers);
        this.httpVersion = other.httpVersion;
        this.method = other.method;
        this.socket.copyFrom(other.socket);
        this.url.copyFrom(other.url);
        this.cookies.copyFrom(other.cookies);
    }

    public boolean hasContent() {
        return this.method != null || this.headers.size() > 0 || this.httpVersion != null || this.cookies.size() > 0 || this.rawBody != null || this.postParams.size() > 0 || this.socket.hasContent() || this.url.hasContent();
    }
}

