/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl;

import co.elastic.apm.bci.ElasticApmAgent;
import co.elastic.apm.configuration.PrefixingConfigurationSourceWrapper;
import co.elastic.apm.configuration.source.PropertyFileConfigurationSource;
import co.elastic.apm.configuration.source.SystemPropertyConfigurationSource;
import co.elastic.apm.context.LifecycleListener;
import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.impl.stacktrace.StacktraceFactory;
import co.elastic.apm.logging.LoggingConfiguration;
import co.elastic.apm.report.Reporter;
import co.elastic.apm.report.ReporterFactory;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.shaded.stagemonitor.configuration.source.AbstractConfigurationSource;
import co.elastic.apm.shaded.stagemonitor.configuration.source.ConfigurationSource;
import co.elastic.apm.shaded.stagemonitor.configuration.source.EnvironmentVariableConfigurationSource;
import co.elastic.apm.shaded.stagemonitor.configuration.source.SimpleSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ElasticApmTracerBuilder {
    private final Logger logger;
    @Nullable
    private ConfigurationRegistry configurationRegistry;
    @Nullable
    private Reporter reporter;
    @Nullable
    private StacktraceFactory stacktraceFactory;
    @Nullable
    private Iterable<LifecycleListener> lifecycleListeners;
    private Map<String, String> inlineConfig = new HashMap<String, String>();

    public ElasticApmTracerBuilder() {
        List<ConfigurationSource> configSources = this.getConfigSources();
        LoggingConfiguration.init(configSources);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public ElasticApmTracerBuilder configurationRegistry(ConfigurationRegistry configurationRegistry) {
        this.configurationRegistry = configurationRegistry;
        return this;
    }

    public ElasticApmTracerBuilder reporter(Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public ElasticApmTracerBuilder stacktraceFactory(StacktraceFactory stacktraceFactory) {
        this.stacktraceFactory = stacktraceFactory;
        return this;
    }

    public ElasticApmTracerBuilder lifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        this.lifecycleListeners = lifecycleListeners;
        return this;
    }

    public ElasticApmTracerBuilder withConfig(String key, String value) {
        this.inlineConfig.put(key, value);
        return this;
    }

    public ElasticApmTracer build() {
        if (this.configurationRegistry == null) {
            List<ConfigurationSource> configSources = this.getConfigSources();
            this.configurationRegistry = this.getDefaultConfigurationRegistry(configSources);
        }
        if (this.reporter == null) {
            this.reporter = new ReporterFactory().createReporter(this.configurationRegistry, null, null);
        }
        if (this.stacktraceFactory == null) {
            StacktraceConfiguration stackConfig = this.configurationRegistry.getConfig(StacktraceConfiguration.class);
            this.stacktraceFactory = new StacktraceFactory.CurrentThreadStackTraceFactory(stackConfig);
        }
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = ServiceLoader.load(LifecycleListener.class, this.getClass().getClassLoader());
        }
        return new ElasticApmTracer(this.configurationRegistry, this.reporter, this.stacktraceFactory, this.lifecycleListeners);
    }

    private ConfigurationRegistry getDefaultConfigurationRegistry(List<ConfigurationSource> configSources) {
        try {
            ConfigurationRegistry configurationRegistry = ConfigurationRegistry.builder().configSources(configSources).optionProviders(ServiceLoader.load(ConfigurationOptionProvider.class, ElasticApmTracer.class.getClassLoader())).failOnMissingRequiredValues(true).build();
            configurationRegistry.scheduleReloadAtRate(30L, TimeUnit.SECONDS);
            return configurationRegistry;
        }
        catch (IllegalStateException e) {
            this.logger.warn(e.getMessage());
            return ConfigurationRegistry.builder().addConfigSource(new SimpleSource("Noop Configuration").add("active", "false").add("instrument", "false").add("service_name", "none").add("sample_rate", "0")).optionProviders(ServiceLoader.load(ConfigurationOptionProvider.class, ElasticApmTracer.class.getClassLoader())).build();
        }
    }

    private List<ConfigurationSource> getConfigSources() {
        ArrayList<ConfigurationSource> result = new ArrayList<ConfigurationSource>();
        result.add(new PrefixingConfigurationSourceWrapper(new SystemPropertyConfigurationSource(), "elastic.apm."));
        result.add(new PrefixingConfigurationSourceWrapper(new EnvironmentVariableConfigurationSource(), "ELASTIC_APM_"));
        result.add(new AbstractConfigurationSource(){

            @Override
            public String getValue(String key) {
                return (String)ElasticApmTracerBuilder.this.inlineConfig.get(key);
            }

            @Override
            public String getName() {
                return "Inline configuration";
            }
        });
        String agentHome = ElasticApmAgent.getAgentHome();
        if (agentHome != null && PropertyFileConfigurationSource.isPresent(agentHome + "/elasticapm.properties")) {
            result.add(new PropertyFileConfigurationSource(agentHome + "/elasticapm.properties"));
        }
        if (PropertyFileConfigurationSource.isPresent("elasticapm.properties")) {
            result.add(new PropertyFileConfigurationSource("elasticapm.properties"));
        }
        return result;
    }
}

