/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.impl;

import co.elastic.apm.configuration.CoreConfiguration;
import co.elastic.apm.context.LifecycleListener;
import co.elastic.apm.impl.error.ErrorCapture;
import co.elastic.apm.impl.sampling.ProbabilitySampler;
import co.elastic.apm.impl.sampling.Sampler;
import co.elastic.apm.impl.stacktrace.Stacktrace;
import co.elastic.apm.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.impl.stacktrace.StacktraceFactory;
import co.elastic.apm.impl.transaction.Span;
import co.elastic.apm.impl.transaction.Transaction;
import co.elastic.apm.objectpool.NoopObjectPool;
import co.elastic.apm.objectpool.ObjectPool;
import co.elastic.apm.objectpool.Recyclable;
import co.elastic.apm.objectpool.RecyclableObjectFactory;
import co.elastic.apm.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.report.Reporter;
import co.elastic.apm.report.ReporterConfiguration;
import co.elastic.apm.shaded.jctools.queues.atomic.AtomicQueueFactory;
import co.elastic.apm.shaded.jctools.queues.spec.ConcurrentQueueSpec;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationRegistry;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ElasticApmTracer {
    public static final double MS_IN_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final Logger logger = LoggerFactory.getLogger(ElasticApmTracer.class);
    private final ConfigurationRegistry configurationRegistry;
    private final StacktraceConfiguration stacktraceConfiguration;
    private final Iterable<LifecycleListener> lifecycleListeners;
    private final ObjectPool<Transaction> transactionPool;
    private final ObjectPool<Span> spanPool;
    private final ObjectPool<Stacktrace> stackTracePool;
    private final ObjectPool<ErrorCapture> errorPool;
    private final Reporter reporter;
    private final StacktraceFactory stacktraceFactory;
    private final ThreadLocal<Transaction> currentTransaction = new ThreadLocal();
    private final ThreadLocal<Span> currentSpan = new ThreadLocal();
    private final CoreConfiguration coreConfiguration;
    private Sampler sampler;

    ElasticApmTracer(ConfigurationRegistry configurationRegistry, Reporter reporter, StacktraceFactory stacktraceFactory, Iterable<LifecycleListener> lifecycleListeners) {
        this.configurationRegistry = configurationRegistry;
        this.reporter = reporter;
        this.stacktraceFactory = stacktraceFactory;
        this.stacktraceConfiguration = configurationRegistry.getConfig(StacktraceConfiguration.class);
        this.lifecycleListeners = lifecycleListeners;
        int maxPooledElements = configurationRegistry.getConfig(ReporterConfiguration.class).getMaxQueueSize() * 2;
        this.transactionPool = new QueueBasedObjectPool<Transaction>(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(maxPooledElements)), false, new RecyclableObjectFactory<Transaction>(){

            @Override
            public Transaction createInstance() {
                return new Transaction();
            }
        });
        this.spanPool = new QueueBasedObjectPool<Span>(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(maxPooledElements)), false, new RecyclableObjectFactory<Span>(){

            @Override
            public Span createInstance() {
                return new Span();
            }
        });
        this.errorPool = new QueueBasedObjectPool<ErrorCapture>(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(maxPooledElements)), false, new RecyclableObjectFactory<ErrorCapture>(){

            @Override
            public ErrorCapture createInstance() {
                return new ErrorCapture();
            }
        });
        this.stackTracePool = new NoopObjectPool<Stacktrace>(new RecyclableObjectFactory<Stacktrace>(){

            @Override
            public Stacktrace createInstance() {
                return new Stacktrace();
            }
        });
        this.coreConfiguration = configurationRegistry.getConfig(CoreConfiguration.class);
        this.sampler = ProbabilitySampler.of(this.coreConfiguration.getSampleRate().get());
        this.coreConfiguration.getSampleRate().addChangeListener(new ConfigurationOption.ChangeListener<Double>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, Double oldValue, Double newValue) {
                ElasticApmTracer.this.sampler = ProbabilitySampler.of(newValue);
            }
        });
        for (LifecycleListener lifecycleListener : lifecycleListeners) {
            lifecycleListener.start(this);
        }
    }

    public Transaction startTransaction() {
        return this.startTransaction(null);
    }

    public Transaction startTransaction(@Nullable String traceContextHeader) {
        Transaction transaction = this.startManualTransaction(traceContextHeader, this.sampler, System.nanoTime());
        this.activate(transaction);
        return transaction;
    }

    public Transaction startManualTransaction(@Nullable String traceContextHeader, Sampler sampler, long nanoTime) {
        Transaction transaction = !this.coreConfiguration.isActive() ? this.noopTransaction() : this.transactionPool.createInstance().start(this, traceContextHeader, nanoTime, sampler);
        if (logger.isDebugEnabled()) {
            logger.debug("startTransaction {} {", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("starting transaction at", new RuntimeException("this exception is just used to record where the transaction has been started from"));
            }
        }
        return transaction;
    }

    public Transaction noopTransaction() {
        return this.transactionPool.createInstance().startNoop(this);
    }

    public void activate(Transaction transaction) {
        this.currentTransaction.set(transaction);
    }

    @Nullable
    public Transaction currentTransaction() {
        return this.currentTransaction.get();
    }

    @Nullable
    public Span currentSpan() {
        return this.currentSpan.get();
    }

    @Nullable
    public Span startSpan() {
        Transaction transaction = this.currentTransaction();
        Span span = this.startManualSpan(transaction, this.currentSpan(), System.nanoTime());
        if (span != null) {
            this.activate(span);
        }
        return span;
    }

    @Nullable
    public Span startManualSpan(@Nullable Transaction transaction, @Nullable Span parentSpan, long nanoTime) {
        if (transaction == null || transaction.isNoop()) {
            return null;
        }
        Span span = this.createRealSpan(transaction, parentSpan, nanoTime);
        if (logger.isDebugEnabled()) {
            logger.debug("startSpan {} {", (Object)span);
            if (logger.isTraceEnabled()) {
                logger.trace("starting span at", new RuntimeException("this exception is just used to record where the span has been started from"));
            }
        }
        return span;
    }

    public void activate(Span span) {
        this.currentSpan.set(span);
    }

    private Span createRealSpan(Transaction transaction, @Nullable Span parentSpan, long nanoTime) {
        boolean dropped;
        Span span = this.spanPool.createInstance();
        if (this.isTransactionSpanLimitReached(transaction)) {
            dropped = true;
            transaction.getSpanCount().getDropped().increment();
        } else {
            dropped = false;
        }
        transaction.getSpanCount().increment();
        span.start(this, transaction, parentSpan, nanoTime, dropped);
        return span;
    }

    private boolean isTransactionSpanLimitReached(Transaction transaction) {
        return this.coreConfiguration.getTransactionMaxSpans() <= transaction.getSpanCount().getTotal();
    }

    public void captureException(@Nullable Exception e) {
        this.captureException(System.currentTimeMillis(), e);
    }

    public void captureException(long epochTimestampMillis, @Nullable Exception e) {
        if (e != null) {
            ErrorCapture error = new ErrorCapture();
            error.withTimestamp(epochTimestampMillis);
            error.getException().withMessage(e.getMessage());
            error.getException().withType(e.getClass().getName());
            this.stacktraceFactory.fillStackTrace(error.getException().getStacktrace(), e.getStackTrace());
            Transaction transaction = this.currentTransaction();
            if (transaction != null) {
                error.getContext().copyFrom(transaction.getContextEnsureVisibility());
                error.asChildOf(transaction);
                error.getTransaction().getTransactionId().copyFrom(transaction.getId());
            }
            this.reporter.report(error);
        }
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configurationRegistry;
    }

    public <T extends ConfigurationOptionProvider> T getConfig(Class<T> pluginClass) {
        return this.configurationRegistry.getConfig(pluginClass);
    }

    public void endTransaction(Transaction transaction, boolean releaseActiveTransaction) {
        if (logger.isDebugEnabled()) {
            logger.debug("} endTransaction {}", (Object)transaction);
            if (logger.isTraceEnabled()) {
                logger.trace("ending transaction at", new RuntimeException("this exception is just used to record where the transaction has been ended from"));
            }
        }
        if (releaseActiveTransaction) {
            if (this.currentTransaction.get() != null && this.currentTransaction.get() != transaction) {
                logger.warn("Trying to end a transaction which is not the current (thread local) transaction!");
                assert (false);
            }
            this.releaseActiveTransaction();
        }
        if (!transaction.isNoop()) {
            this.reporter.report(transaction);
        } else {
            transaction.recycle();
        }
    }

    public void endSpan(Span span, boolean releaseActiveSpan) {
        int spanFramesMinDurationMs;
        if (logger.isDebugEnabled()) {
            logger.debug("} endSpan {}", (Object)span.toString());
            if (logger.isTraceEnabled()) {
                logger.trace("ending span at", new RuntimeException("this exception is just used to record where the span has been ended from"));
            }
        }
        if (releaseActiveSpan) {
            if (this.currentSpan.get() != null && this.currentSpan.get() != span) {
                logger.warn("Trying to end a span which is not the current (thread local) span!");
                assert (false);
            }
            this.releaseActiveSpan();
        }
        if ((spanFramesMinDurationMs = this.stacktraceConfiguration.getSpanFramesMinDurationMs()) != 0 && span.isSampled() && span.getDuration() >= (double)spanFramesMinDurationMs) {
            this.stacktraceFactory.fillStackTrace(span.getStacktrace());
        }
        if (span.isSampled()) {
            this.reporter.report(span);
        } else {
            span.recycle();
        }
    }

    public void recycle(Transaction transaction) {
        List<Span> spans = transaction.getSpans();
        for (int i = 0; i < spans.size(); ++i) {
            this.recycle(spans.get(i));
        }
        this.transactionPool.recycle(transaction);
    }

    public void recycle(Span span) {
        List<Stacktrace> stacktrace = span.getStacktrace();
        for (int i = 0; i < stacktrace.size(); ++i) {
            this.stackTracePool.recycle((Stacktrace)((Recyclable)stacktrace.get(i)));
        }
        this.spanPool.recycle(span);
    }

    public void recycle(ErrorCapture error) {
        this.errorPool.recycle(error);
    }

    public void stop() {
        try {
            this.configurationRegistry.close();
            this.reporter.close();
            this.transactionPool.close();
            this.spanPool.close();
            this.stackTracePool.close();
            this.errorPool.close();
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.stop();
            }
        }
        catch (Exception e) {
            logger.warn("Suppressed exception while calling stop()", e);
        }
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public void releaseActiveTransaction() {
        this.currentTransaction.set(null);
    }

    public void releaseActiveSpan() {
        this.currentSpan.set(null);
    }
}

