/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.configuration;

import co.elastic.apm.context.LifecycleListener;
import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.util.VersionUtils;

public class StartupInfo
implements LifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(StartupInfo.class);
    private final String elasticApmVersion;

    public StartupInfo() {
        String version = VersionUtils.getVersionFromPomProperties(this.getClass(), "co.elastic.apm", "elastic-apm-agent");
        this.elasticApmVersion = version != null ? version : "(unknown version)";
    }

    private static String getJvmAndOsVersionString() {
        return "Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ") " + System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    @Override
    public void start(ElasticApmTracer tracer) {
        logger.info("Starting Elastic APM {} on {}", (Object)this.elasticApmVersion, (Object)StartupInfo.getJvmAndOsVersionString());
        for (ConfigurationOption<?> option : tracer.getConfigurationRegistry().getConfigurationOptionsByKey().values()) {
            if (option.isDefault()) continue;
            logger.debug("{}: '{}' (source: {})", option.getKey(), option.isSensitive() ? "XXXX" : option.getValueAsSafeString(), option.getNameOfCurrentConfigurationSource());
        }
    }

    @Override
    public void stop() throws Exception {
    }
}

