/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.configuration;

import co.elastic.apm.configuration.validation.RegexValidator;
import co.elastic.apm.matcher.WildcardMatcher;
import co.elastic.apm.matcher.WildcardMatcherValueConverter;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.shaded.stagemonitor.configuration.converter.ListValueConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CoreConfiguration
extends ConfigurationOptionProvider {
    public static final String ACTIVE = "active";
    public static final String INSTRUMENT = "instrument";
    public static final String SERVICE_NAME = "service_name";
    public static final String SAMPLE_RATE = "sample_rate";
    private static final String CORE_CATEGORY = "Core";
    private final ConfigurationOption<Boolean> active = ConfigurationOption.booleanOption().key("active").configurationCategory("Core").description("A boolean specifying if the agent should be active or not. If active, the agent will instrument incoming HTTP requests and track errors.\n\nYou can use this setting to dynamically disable Elastic APM at runtime.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<Boolean> instrument = ConfigurationOption.booleanOption().key("instrument").configurationCategory("Core").description("A boolean specifying if the agent should instrument the application to collect performance metrics for the app. When set to false, Elastic APM will not affect your application at all.\n\nNOTE: Both active and instrument needs to be true for instrumentation to be running.").buildWithDefault(true);
    private final ConfigurationOption<String> serviceName = ConfigurationOption.stringOption().key("service_name").configurationCategory("Core").label("The name of your service").description("This is used to keep all the errors and transactions of your service together\nand is the primary filter in the Elastic APM user interface.\n\nNOTE: The service name must conform to this regular expression: ^[a-zA-Z0-9 _-]+$. In less regexy terms: Your service name must only contain characters from the ASCII alphabet, numbers, dashes, underscores and spaces.").addValidator(RegexValidator.of("^[a-zA-Z0-9 _-]+$", "Your service name \"{0}\" must only contain characters from the ASCII alphabet, numbers, dashes, underscores and spaces")).buildRequired();
    private final ConfigurationOption<String> serviceVersion = ConfigurationOption.stringOption().key("service_version").configurationCategory("Core").description("A version string for the currently deployed version of the service. If you don\u2019t version your deployments, the recommended value for this field is the commit identifier of the deployed revision, e.g. the output of git rev-parse HEAD.").build();
    private final ConfigurationOption<String> environment = ConfigurationOption.stringOption().key("environment").configurationCategory("Core").description("The name of the environment this service is deployed in, e.g. \"production\" or \"staging\".").build();
    private final ConfigurationOption<Double> sampleRate = ConfigurationOption.doubleOption().key("sample_rate").configurationCategory("Core").description("By default, the agent will sample every transaction (e.g. request to your service). To reduce overhead and storage requirements, you can set the sample rate to a value between 0.0 and 1.0. We still record overall time and the result for unsampled transactions, but no context information, tags, or spans.").dynamic(true).addValidator(new ConfigurationOption.Validator<Double>(){

        @Override
        public void assertValid(Double value) {
            if (value != null && (value < 0.0 || value > 1.0)) {
                throw new IllegalArgumentException("The sample rate must be between 0 and 1");
            }
        }
    }).buildWithDefault(1.0);
    private final ConfigurationOption<Integer> transactionMaxSpans = ConfigurationOption.integerOption().key("transaction_max_spans").configurationCategory("Core").description("Limits the amount of spans that are recorded per transaction.\n\nThis is helpful in cases where a transaction creates a very high amount of spans (e.g. thousands of SQL queries).\n\nSetting an upper limit will prevent overloading the agent and the APM server with too much work for such edge cases.").dynamic(true).buildWithDefault(500);
    private final ConfigurationOption<List<WildcardMatcher>> sanitizeFieldNames = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("sanitize_field_names").configurationCategory("Core").description("Sometimes it is necessary to sanitize the data sent to Elastic APM,\ne.g. remove sensitive data.\n\nConfigure a list of wildcard patterns of field names which should be sanitized.\nThese apply for example to HTTP headers and `application/x-www-form-urlencoded` data.\n\nEntries can have a wildcard at the beginning and at the end.\nPrepending an element with `(?i)` makes the matching case-insensitive.\n\nNOTE: Data in the query string is considered non-sensitive,\nas sensitive information should not be sent in the query string.\nSee https://www.owasp.org/index.php/Information_exposure_through_query_strings_in_url for more information\n\nNOTE: Review the data captured by Elastic APM carefully to make sure it does not capture sensitive information.\nIf you do find sensitive data in the Elasticsearch index,\nyou should add an additional entry to this list (make sure to also include the default entries).").dynamic(true).tags("security").buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("(?i)password"), WildcardMatcher.valueOf("(?i)passwd"), WildcardMatcher.valueOf("(?i)pwd"), WildcardMatcher.valueOf("(?i)secret"), WildcardMatcher.valueOf("(?i)token"), WildcardMatcher.valueOf("(?i)*key"), WildcardMatcher.valueOf("(?i)*token"), WildcardMatcher.valueOf("(?i)*session*"), WildcardMatcher.valueOf("(?i)*credit*"), WildcardMatcher.valueOf("(?i)*card*"), WildcardMatcher.valueOf("(?i)authorization"), WildcardMatcher.valueOf("(?i)set-cookie")));
    private final ConfigurationOption<Boolean> distributedTracing = ConfigurationOption.booleanOption().key("distributed_tracing").configurationCategory("Core").tags("internal").description("Enables distributed tracing and uses the updated json schema to serialize payloads, transactions and spans").buildWithDefault(false);
    private final ConfigurationOption<Collection<String>> disabledInstrumentations = ConfigurationOption.stringsOption().key("disabled_instrumentations").configurationCategory("Core").description("A list of instrumentations which should be disabled. Valid options are `jdbc`, `servlet-api` and `spring-mvc`.").buildWithDefault(Collections.emptyList());

    public boolean isActive() {
        return this.active.get();
    }

    public boolean isInstrument() {
        return this.instrument.get();
    }

    public String getServiceName() {
        return this.serviceName.get();
    }

    public String getServiceVersion() {
        return this.serviceVersion.get();
    }

    public String getEnvironment() {
        return this.environment.get();
    }

    public ConfigurationOption<Double> getSampleRate() {
        return this.sampleRate;
    }

    public int getTransactionMaxSpans() {
        return this.transactionMaxSpans.get();
    }

    public List<WildcardMatcher> getSanitizeFieldNames() {
        return this.sanitizeFieldNames.get();
    }

    public boolean isDistributedTracingEnabled() {
        return this.distributedTracing.get();
    }

    public Collection<String> getDisabledInstrumentations() {
        return this.disabledInstrumentations.get();
    }
}

