/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.bci;

import co.elastic.apm.bci.ElasticApmInstrumentation;
import co.elastic.apm.bci.bytebuddy.ClassLoaderNameMatcher;
import co.elastic.apm.bci.bytebuddy.ErrorLoggingListener;
import co.elastic.apm.configuration.CoreConfiguration;
import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.impl.ElasticApmTracerBuilder;
import co.elastic.apm.shaded.bytebuddy.ByteBuddy;
import co.elastic.apm.shaded.bytebuddy.agent.builder.AgentBuilder;
import co.elastic.apm.shaded.bytebuddy.agent.builder.ResettableClassFileTransformer;
import co.elastic.apm.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.shaded.bytebuddy.dynamic.scaffold.MethodGraph;
import co.elastic.apm.shaded.bytebuddy.dynamic.scaffold.TypeValidation;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.shaded.bytebuddy.utility.JavaModule;
import co.elastic.apm.shaded.slf4j.Logger;
import co.elastic.apm.shaded.slf4j.LoggerFactory;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.ServiceLoader;
import javax.annotation.Nullable;

public class ElasticApmAgent {
    @Nullable
    private static Instrumentation instrumentation;
    @Nullable
    private static ResettableClassFileTransformer resettableClassFileTransformer;

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        ElasticApmAgent.initInstrumentation(new ElasticApmTracerBuilder().build(), instrumentation);
    }

    public static void agentmain(String agentArguments, Instrumentation instrumentation) {
        ElasticApmAgent.initInstrumentation(new ElasticApmTracerBuilder().build(), instrumentation);
    }

    public static void initInstrumentation(ElasticApmTracer tracer, Instrumentation instrumentation) {
        ElasticApmAgent.initInstrumentation(tracer, instrumentation, ServiceLoader.load(ElasticApmInstrumentation.class, ElasticApmInstrumentation.class.getClassLoader()));
    }

    public static void initInstrumentation(ElasticApmTracer tracer, Instrumentation instrumentation, Iterable<ElasticApmInstrumentation> instrumentations) {
        Logger logger = LoggerFactory.getLogger(ElasticApmAgent.class);
        if (ElasticApmAgent.instrumentation != null) {
            logger.warn("Instrumentation has already been initialized");
            return;
        }
        ElasticApmAgent.instrumentation = instrumentation;
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(logger.isDebugEnabled())).with(MethodGraph.Compiler.ForDeclaredMethods.INSTANCE);
        AgentBuilder agentBuilder = ElasticApmAgent.getAgentBuilder(byteBuddy);
        int numberOfAdvices = 0;
        for (ElasticApmInstrumentation advice : instrumentations) {
            if (!ElasticApmAgent.isIncluded(advice, tracer.getConfig(CoreConfiguration.class))) continue;
            ++numberOfAdvices;
            agentBuilder = ElasticApmAgent.applyAdvice(tracer, agentBuilder, advice);
        }
        logger.debug("Applied {} advices", (Object)numberOfAdvices);
        resettableClassFileTransformer = agentBuilder.installOn(ElasticApmAgent.instrumentation);
    }

    private static boolean isIncluded(ElasticApmInstrumentation advice, CoreConfiguration coreConfiguration) {
        Collection<String> disabledInstrumentations = coreConfiguration.getDisabledInstrumentations();
        return !ElasticApmAgent.isGroupDisabled(disabledInstrumentations, advice.getInstrumentationGroupName()) && ElasticApmAgent.isInstrumentationEnabled(advice, coreConfiguration);
    }

    private static boolean isGroupDisabled(Collection<String> disabledInstrumentations, String instrumentationGroupName) {
        return disabledInstrumentations.contains(instrumentationGroupName);
    }

    private static boolean isInstrumentationEnabled(ElasticApmInstrumentation advice, CoreConfiguration coreConfiguration) {
        return advice.includeWhenInstrumentationIsDisabled() || coreConfiguration.isInstrument();
    }

    private static AgentBuilder applyAdvice(ElasticApmTracer tracer, AgentBuilder agentBuilder, final ElasticApmInstrumentation advice) {
        final Logger logger = LoggerFactory.getLogger(ElasticApmAgent.class);
        logger.debug("Applying advice {}", (Object)advice.getClass().getName());
        advice.init(tracer);
        return agentBuilder.type(new AgentBuilder.RawMatcher(){

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                boolean typeMatches;
                try {
                    typeMatches = advice.getTypeMatcher().matches(typeDescription);
                }
                catch (Exception ignored) {
                    typeMatches = false;
                }
                if (typeMatches) {
                    logger.debug("Type match for advice {}: {} matches {}", advice.getClass().getSimpleName(), advice.getTypeMatcher(), typeDescription);
                }
                return typeMatches;
            }
        }).transform(new AgentBuilder.Transformer.ForAdvice().advice((ElementMatcher<? super MethodDescription>)new ElementMatcher<MethodDescription>(){

            @Override
            public boolean matches(MethodDescription target) {
                boolean matches = advice.getMethodMatcher().matches(target);
                if (matches) {
                    logger.debug("Method match for advice {}: {} matches {}", advice.getClass().getSimpleName(), advice.getMethodMatcher(), target);
                }
                return matches;
            }
        }, advice.getAdviceClass().getName()).include(advice.getAdviceClass().getClassLoader()).withExceptionHandler(Advice.ExceptionHandler.Default.PRINTING)).asDecorator();
    }

    public static synchronized void reset() {
        if (resettableClassFileTransformer == null || instrumentation == null) {
            throw new IllegalStateException("Reset was called before init");
        }
        resettableClassFileTransformer.reset(instrumentation, AgentBuilder.RedefinitionStrategy.RETRANSFORMATION);
        instrumentation = null;
        resettableClassFileTransformer = null;
    }

    private static AgentBuilder getAgentBuilder(ByteBuddy byteBuddy) {
        return ((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)new AgentBuilder.Default(byteBuddy).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(new ErrorLoggingListener()).ignore(ElementMatchers.any(), ClassLoaderNameMatcher.isReflectionClassLoader()).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithName("org.codehaus.groovy.runtime.callsite.CallSiteClassLoader"))).or(ElementMatchers.nameStartsWith("java."))).or(ElementMatchers.nameStartsWith("com.sun."))).or(ElementMatchers.nameStartsWith("sun"))).or(ElementMatchers.nameStartsWith("org.aspectj."))).or(ElementMatchers.nameStartsWith("org.groovy."))).or(ElementMatchers.nameStartsWith("com.p6spy."))).or(ElementMatchers.nameStartsWith("co.elastic.apm.shaded.bytebuddy."))).or(ElementMatchers.nameContains("javassist"))).or(ElementMatchers.nameContains(".asm."))).disableClassFormatChanges();
    }

    @Nullable
    public static String getAgentHome() {
        try {
            File agentJar = new File(ElasticApmAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!agentJar.getName().endsWith(".jar")) {
                return null;
            }
            return agentJar.getAbsoluteFile().getParent();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

