/*
 * Decompiled with CFR 0.152.
 */
package org.stagemonitor.configuration.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.configuration.source.AbstractConfigurationSource;
import org.stagemonitor.util.IOUtils;

public final class PropertyFileConfigurationSource
extends AbstractConfigurationSource {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileConfigurationSource.class);
    private final String location;
    private Properties properties;
    private File file;
    private boolean writeable;

    public PropertyFileConfigurationSource(String location) {
        this.location = location;
        try {
            this.file = IOUtils.getFile(location);
            this.writeable = this.file.canWrite();
        }
        catch (Exception e) {
            this.writeable = false;
        }
        this.reload();
    }

    @Override
    public void reload() {
        this.properties = PropertyFileConfigurationSource.getProperties(this.location);
        if (this.properties == null) {
            logger.warn("Could not load {}", (Object)this.location);
            this.properties = new Properties();
        }
    }

    @Override
    public boolean isSavingPersistent() {
        return true;
    }

    @Override
    public String getName() {
        return this.location;
    }

    public static boolean isPresent(String location) {
        return PropertyFileConfigurationSource.getProperties(location) != null;
    }

    private static Properties getProperties(String location) {
        if (location == null) {
            return null;
        }
        Properties props = PropertyFileConfigurationSource.getFromClasspath(location, PropertyFileConfigurationSource.class.getClassLoader());
        if (props == null) {
            props = PropertyFileConfigurationSource.getFromFileSystem(location);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getFromClasspath(String classpathLocation, ClassLoader classLoader) {
        Properties props = new Properties();
        InputStream resourceStream = classLoader.getResourceAsStream(classpathLocation);
        if (resourceStream != null) {
            try {
                props.load(resourceStream);
                Properties properties = props;
                return properties;
            }
            catch (IOException e) {
                logger.warn(e.getMessage() + " (this exception is ignored)", e);
            }
            finally {
                try {
                    resourceStream.close();
                }
                catch (IOException e) {
                    logger.warn(e.getMessage() + " (this exception is ignored)", e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFromFileSystem(String location) {
        Properties props = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(location);
            props.load(input);
            Properties properties = props;
            return properties;
        }
        catch (FileNotFoundException ex) {
            Properties properties = null;
            return properties;
        }
        catch (IOException e) {
            logger.warn(e.getMessage() + " (this exception is ignored)", e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    logger.warn(e.getMessage() + " (this exception is ignored)", e);
                }
            }
        }
        return null;
    }

    @Override
    public String getValue(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public boolean isSavingPossible() {
        return this.writeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String key, String value) throws IOException {
        if (this.file != null) {
            PropertyFileConfigurationSource propertyFileConfigurationSource = this;
            synchronized (propertyFileConfigurationSource) {
                this.properties.put(key, value);
                FileOutputStream out = new FileOutputStream(this.file);
                this.properties.store(out, null);
                out.flush();
                out.close();
            }
        } else {
            throw new IOException(this.location + " is not writeable");
        }
    }
}

