/*
 * Decompiled with CFR 0.152.
 */
package org.stagemonitor.configuration.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.stagemonitor.configuration.converter.AbstractValueConverter;

public class JsonValueConverter<T>
extends AbstractValueConverter<T> {
    private final TypeReference<T> typeReference;
    private final ObjectMapper objectMapper;

    public JsonValueConverter(TypeReference<T> typeReference) {
        this.typeReference = typeReference;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public T convert(String s) {
        try {
            return (T)this.objectMapper.readValue(s, this.typeReference);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toString(T value) {
        if (value == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

