/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.BinaryConverter;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.SerializationException;
import com.dslplatform.json.StringConverter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;

public abstract class JavaGeomConverter {
    static final JsonReader.ReadObject<Point2D.Double> LocationReader = new JsonReader.ReadObject<Point2D.Double>(){

        @Override
        @Nullable
        public Point2D.Double read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializeLocation(reader);
        }
    };
    static final JsonWriter.WriteObject<Point2D> LocationWriter = new JsonWriter.WriteObject<Point2D>(){

        @Override
        public void write(JsonWriter writer, @Nullable Point2D value) {
            JavaGeomConverter.serializeLocationNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Point> PointReader = new JsonReader.ReadObject<Point>(){

        @Override
        @Nullable
        public Point read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializePoint(reader);
        }
    };
    static final JsonWriter.WriteObject<Point> PointWriter = new JsonWriter.WriteObject<Point>(){

        @Override
        public void write(JsonWriter writer, @Nullable Point value) {
            JavaGeomConverter.serializePointNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Rectangle2D.Double> RectangleReader = new JsonReader.ReadObject<Rectangle2D.Double>(){

        @Override
        @Nullable
        public Rectangle2D.Double read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializeRectangle(reader);
        }
    };
    static final JsonWriter.WriteObject<Rectangle2D> RectangleWriter = new JsonWriter.WriteObject<Rectangle2D>(){

        @Override
        public void write(JsonWriter writer, @Nullable Rectangle2D value) {
            JavaGeomConverter.serializeRectangleNullable(value, writer);
        }
    };
    static final JsonWriter.WriteObject<Image> ImageWriter = new JsonWriter.WriteObject<Image>(){

        @Override
        public void write(JsonWriter writer, @Nullable Image value) {
            JavaGeomConverter.serialize(value, writer);
        }
    };
    static final JsonReader.ReadObject<BufferedImage> ImageReader = new JsonReader.ReadObject<BufferedImage>(){

        @Override
        @Nullable
        public BufferedImage read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : JavaGeomConverter.deserializeImage(reader);
        }
    };

    public static void serializeLocationNullable(@Nullable Point2D value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaGeomConverter.serializeLocation(value, sw);
        }
    }

    public static void serializeLocation(Point2D value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.getX(), sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.getY(), sw);
        sw.writeByte((byte)125);
    }

    public static Point2D.Double deserializeLocation(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expecting '{' for object start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Point2D.Double();
        }
        double x = 0.0;
        double y = 0.0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw reader.newParseError("Expecting ':' after attribute name");
        }
        reader.getNextToken();
        double value = NumberConverter.deserializeDouble(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw reader.newParseError("Expecting ':' after attribute name");
            }
            reader.getNextToken();
            value = NumberConverter.deserializeDouble(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if (!"Y".equalsIgnoreCase(name)) continue;
            y = value;
        }
        if (nextToken != 125) {
            throw reader.newParseError("Expecting '}' for object end");
        }
        return new Point2D.Double(x, y);
    }

    public static ArrayList<Point2D> deserializeLocationCollection(JsonReader reader) throws IOException {
        ArrayList<Point2D> res = new ArrayList<Point2D>(4);
        reader.deserializeCollection(LocationReader, res);
        return res;
    }

    public static void deserializeLocationCollection(JsonReader reader, Collection<Point2D> res) throws IOException {
        reader.deserializeCollection(LocationReader, res);
    }

    public static ArrayList<Point2D> deserializeLocationNullableCollection(JsonReader reader) throws IOException {
        ArrayList<Point2D> res = new ArrayList<Point2D>(4);
        reader.deserializeNullableCollection(LocationReader, res);
        return res;
    }

    public static void deserializeLocationNullableCollection(JsonReader reader, Collection<Point2D> res) throws IOException {
        reader.deserializeNullableCollection(LocationReader, res);
    }

    public static void serializePointNullable(@Nullable Point value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaGeomConverter.serializePoint(value, sw);
        }
    }

    public static void serializePoint(Point value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.x, sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.y, sw);
        sw.writeByte((byte)125);
    }

    public static Point deserializePoint(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expecting '{' for object start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Point();
        }
        int x = 0;
        int y = 0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw reader.newParseError("Expecting ':' after attribute name");
        }
        reader.getNextToken();
        int value = NumberConverter.deserializeInt(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw reader.newParseError("Expecting ':' after attribute name");
            }
            reader.getNextToken();
            value = NumberConverter.deserializeInt(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if (!"Y".equalsIgnoreCase(name)) continue;
            y = value;
        }
        if (nextToken != 125) {
            throw reader.newParseError("Expecting '}' for object end");
        }
        return new Point(x, y);
    }

    public static ArrayList<Point> deserializePointCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(PointReader);
    }

    public static void deserializePointCollection(JsonReader reader, Collection<Point> res) throws IOException {
        reader.deserializeCollection(PointReader, res);
    }

    public static ArrayList<Point> deserializePointNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(PointReader);
    }

    public static void deserializePointNullableCollection(JsonReader reader, Collection<Point> res) throws IOException {
        reader.deserializeNullableCollection(PointReader, res);
    }

    public static void serializeRectangleNullable(@Nullable Rectangle2D value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JavaGeomConverter.serializeRectangle(value, sw);
        }
    }

    public static void serializeRectangle(Rectangle2D value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.getX(), sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.getY(), sw);
        sw.writeAscii(",\"Width\":");
        NumberConverter.serialize(value.getWidth(), sw);
        sw.writeAscii(",\"Height\":");
        NumberConverter.serialize(value.getHeight(), sw);
        sw.writeByte((byte)125);
    }

    public static Rectangle2D.Double deserializeRectangle(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expecting '{' for object start");
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Rectangle2D.Double();
        }
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        double height = 0.0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw reader.newParseError("Expecting ':' after attribute name");
        }
        reader.getNextToken();
        double value = NumberConverter.deserializeDouble(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        } else if ("Width".equalsIgnoreCase(name)) {
            width = value;
        } else if ("Height".equalsIgnoreCase(name)) {
            height = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw reader.newParseError("Expecting ':' after attribute name");
            }
            reader.getNextToken();
            value = NumberConverter.deserializeDouble(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if ("Y".equalsIgnoreCase(name)) {
                y = value;
                continue;
            }
            if ("Width".equalsIgnoreCase(name)) {
                width = value;
                continue;
            }
            if (!"Height".equalsIgnoreCase(name)) continue;
            height = value;
        }
        if (nextToken != 125) {
            throw reader.newParseError("Expecting '}' for object end");
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleCollection(JsonReader reader) throws IOException {
        ArrayList<Rectangle2D> res = new ArrayList<Rectangle2D>(4);
        reader.deserializeCollection(RectangleReader, res);
        return res;
    }

    public static void deserializeRectangleCollection(JsonReader reader, Collection<Rectangle2D> res) throws IOException {
        reader.deserializeCollection(RectangleReader, res);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleNullableCollection(JsonReader reader) throws IOException {
        ArrayList<Rectangle2D> res = new ArrayList<Rectangle2D>(4);
        reader.deserializeNullableCollection(RectangleReader, res);
        return res;
    }

    public static void deserializeRectangleNullableCollection(JsonReader reader, Collection<Rectangle2D> res) throws IOException {
        reader.deserializeNullableCollection(RectangleReader, res);
    }

    public static void serialize(@Nullable Image value, JsonWriter sw) {
        RenderedImage image;
        if (value == null) {
            sw.writeNull();
            return;
        }
        if (value instanceof RenderedImage) {
            image = (RenderedImage)((Object)value);
        } else {
            BufferedImage bufferedImage = new BufferedImage(value.getWidth(null), value.getHeight(null), 6);
            Graphics2D bGr = bufferedImage.createGraphics();
            bGr.drawImage(value, 0, 0, null);
            bGr.dispose();
            image = bufferedImage;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write(image, "png", baos);
            BinaryConverter.serialize(baos.toByteArray(), sw);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public static BufferedImage deserializeImage(JsonReader reader) throws IOException {
        byte[] content = BinaryConverter.deserialize(reader);
        return ImageIO.read(new ByteArrayInputStream(content));
    }

    public static ArrayList<BufferedImage> deserializeImageCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(ImageReader);
    }

    public static void deserializeImageCollection(JsonReader reader, Collection<BufferedImage> res) throws IOException {
        reader.deserializeCollection(ImageReader, res);
    }

    public static ArrayList<BufferedImage> deserializeImageNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(ImageReader);
    }

    public static void deserializeImageNullableCollection(JsonReader reader, Collection<BufferedImage> res) throws IOException {
        reader.deserializeNullableCollection(ImageReader, res);
    }
}

