/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.websocket;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class BaseServerEndpointInstrumentation
extends TracerAwareInstrumentation {
    private final Collection<String> applicationPackages;

    public BaseServerEndpointInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass(this.getServerEndpointClassName()));
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any());
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(ElementMatchers.isAnnotatedWith(ElementMatchers.named(this.getServerEndpointClassName())));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.namedOneOf("javax.websocket.OnOpen", "jakarta.websocket.OnOpen").or(ElementMatchers.namedOneOf("javax.websocket.OnMessage", "jakarta.websocket.OnMessage")).or(ElementMatchers.namedOneOf("javax.websocket.OnError", "jakarta.websocket.OnError")).or(ElementMatchers.namedOneOf("javax.websocket.OnClose", "jakarta.websocket.OnClose")));
    }

    protected abstract String getServerEndpointClassName();

    protected static class BaseAdvice {
        protected BaseAdvice() {
        }

        @Nullable
        protected static Object startTransactionOrSetTransactionName(String signature, String frameworkName, @Nullable String frameworkVersion) {
            Transaction currentTransaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (currentTransaction == null) {
                Transaction rootTransaction = TracerAwareInstrumentation.tracer.startRootTransaction(Thread.currentThread().getContextClassLoader());
                if (rootTransaction != null) {
                    BaseAdvice.setTransactionTypeAndName(rootTransaction, signature, frameworkName, frameworkVersion);
                    return rootTransaction.activate();
                }
            } else {
                BaseAdvice.setTransactionTypeAndName(currentTransaction, signature, frameworkName, frameworkVersion);
            }
            return null;
        }

        protected static void endTransaction(@Nullable Object transactionOrNull, @Advice.Thrown @Nullable Throwable t) {
            if (transactionOrNull == null) {
                return;
            }
            Transaction transaction = (Transaction)transactionOrNull;
            try {
                if (t != null) {
                    ((Transaction)transaction.captureException(t)).withOutcome(Outcome.FAILURE);
                }
            }
            finally {
                ((Transaction)transaction.deactivate()).end();
            }
        }

        private static void setTransactionTypeAndName(Transaction transaction, String signature, String frameworkName, @Nullable String frameworkVersion) {
            transaction.withType("request");
            transaction.withName(signature, 100, false);
            transaction.setFrameworkName(frameworkName);
            transaction.setFrameworkVersion(frameworkVersion);
        }
    }
}

