/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v4.web;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.vertx.v4.Vertx4Instrumentation;
import co.elastic.apm.agent.vertx.v4.web.NoopVertxTracer;
import co.elastic.apm.agent.vertx.v4.web.WebHelper;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class WebInstrumentation
extends Vertx4Instrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("vertx", "vertx-web", "experimental");
    }

    public static class RequestBufferInstrumentation
    extends WebInstrumentation {
        @Override
        public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameStartsWith("io.vertx.core.http.impl").or(ElementMatchers.nameStartsWith("io.vertx.ext.web.impl"));
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("io.vertx.core.http.HttpServerRequest")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.namedOneOf("onData", "handleData").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.buffer.Buffer")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.web.WebInstrumentation$RequestBufferInstrumentation$HandleDataAdvice";
        }

        public static class HandleDataAdvice {
            private static final WebHelper helper = WebHelper.getInstance();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void wrapHandler(@Advice.Argument(value=0) Buffer requestDataBuffer, @Advice.FieldValue(value="context") Context context) {
                Transaction transaction = (Transaction)context.getLocal((Object)WebHelper.CONTEXT_TRANSACTION_KEY);
                helper.captureBody(transaction, requestDataBuffer);
            }
        }
    }

    public static class RouteInstrumentation
    extends WebInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.named("io.vertx.ext.web.impl.RouteState"));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("handleContext").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.ext.web.impl.RoutingContextImplBase")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.web.WebInstrumentation$RouteInstrumentation$RouteImplAdvice";
        }

        public static class RouteImplAdvice {
            private static final WebHelper helper = WebHelper.getInstance();

            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object nextEnter(@Advice.Argument(value=0) RoutingContext routingContext) {
                Transaction transaction = helper.setRouteBasedNameForCurrentTransaction(routingContext);
                if (transaction != null) {
                    transaction.activate();
                }
                return transaction;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void nextExit(@Advice.Argument(value=0) RoutingContext routingContext, @Nullable @Advice.Enter Object transactionObj, @Nullable @Advice.Thrown Throwable thrown) {
                if (transactionObj instanceof Transaction) {
                    Transaction transaction = (Transaction)transactionObj;
                    ((Transaction)transaction.captureException(thrown)).deactivate();
                }
            }
        }
    }

    public static class VertxTracerSendResponseInstrumentation
    extends VertxTracerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("sendResponse").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.Context")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.web.WebInstrumentation$VertxTracerSendResponseInstrumentation$TracerSendResponseAdvice";
        }

        public static class TracerSendResponseAdvice {
            private static final WebHelper helper = WebHelper.getInstance();

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void receiveRequest(@Advice.Argument(value=0) Context context, @Advice.Argument(value=1) Object response, @Nullable @Advice.Argument(value=3) Throwable failure) {
                Object transactionObj = context.getLocal((Object)WebHelper.CONTEXT_TRANSACTION_KEY);
                if (transactionObj instanceof Transaction) {
                    Transaction transaction = (Transaction)transactionObj;
                    if (failure != null) {
                        transaction.captureException(failure);
                    }
                    if (response instanceof HttpServerResponse) {
                        helper.finalizeTransaction((HttpServerResponse)response, transaction);
                    } else {
                        transaction.end();
                    }
                }
            }
        }
    }

    public static class VertxTracerReceiveRequestInstrumentation
    extends VertxTracerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("receiveRequest").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.Context")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.web.WebInstrumentation$VertxTracerReceiveRequestInstrumentation$TracerReceiveRequestAdvice";
        }

        public static class TracerReceiveRequestAdvice {
            private static final WebHelper helper = WebHelper.getInstance();

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void receiveRequest(@Advice.Argument(value=0) Context context, @Advice.Argument(value=3) Object request) {
                if (request instanceof HttpServerRequest) {
                    HttpServerRequest httpServerRequest = (HttpServerRequest)request;
                    helper.startOrGetTransaction(context, httpServerRequest);
                }
            }
        }
    }

    public static abstract class VertxTracerInstrumentation
    extends WebInstrumentation {
        @Override
        public final ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameContains("Tracer");
        }

        @Override
        public final ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.hasSuperType(ElementMatchers.named("io.vertx.core.spi.tracing.VertxTracer")).and(ElementMatchers.not(ElementMatchers.isInterface()));
        }
    }

    public static class ContextImplTracerInstrumentation
    extends WebInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("io.vertx.core.impl.ContextImpl").or(ElementMatchers.named("io.vertx.core.impl.ContextBase")).and(ElementMatchers.not(ElementMatchers.isInterface()));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("tracer").and(ElementMatchers.takesNoArguments());
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v4.web.WebInstrumentation$ContextImplTracerInstrumentation$ContextImplTracerAdvice";
        }

        public static class ContextImplTracerAdvice {
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static VertxTracer<?, ?> receiveRequest(@Advice.Return @Nullable VertxTracer<?, ?> currentTracer) {
                return currentTracer == null ? NoopVertxTracer.INSTANCE : currentTracer;
            }
        }
    }
}

