/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v4.web;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.vertx.AbstractVertxWebHelper;
import io.vertx.core.Context;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import javax.annotation.Nullable;

public class WebHelper
extends AbstractVertxWebHelper {
    private static final WebHelper INSTANCE = new WebHelper(GlobalTracer.requireTracerImpl());

    public static WebHelper getInstance() {
        return INSTANCE;
    }

    private WebHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Nullable
    public Transaction startOrGetTransaction(Context context, HttpServerRequest httpServerRequest) {
        Transaction transaction = super.startOrGetTransaction(httpServerRequest);
        if (transaction != null) {
            this.enrichRequest(httpServerRequest, transaction);
            context.putLocal((Object)CONTEXT_TRANSACTION_KEY, (Object)transaction);
        }
        return transaction;
    }

    @Override
    @Nullable
    public Transaction setRouteBasedNameForCurrentTransaction(RoutingContext routingContext) {
        Context context = routingContext.vertx().getOrCreateContext();
        Transaction transaction = (Transaction)context.getLocal((Object)CONTEXT_TRANSACTION_KEY);
        if (transaction != null) {
            this.setRouteBasedTransactionName(transaction, routingContext);
        }
        return transaction;
    }
}

