/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.webclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.vertx.AbstractVertxWebClientHelper;
import co.elastic.apm.agent.vertx.v3.Vertx3Instrumentation;
import io.vertx.core.Context;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpContext;
import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class WebClientInstrumentation
extends Vertx3Instrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("vertx", "vertx-webclient", "http-client", "experimental");
    }

    public static class HttpContextFollowRedirectInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("followRedirect");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.webclient.WebClientInstrumentation$HttpContextFollowRedirectInstrumentation$HttpContextFollowRedirectAdvice";
        }

        public static class HttpContextFollowRedirectAdvice
        extends AdviceBase {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void followRedirect(@Advice.This HttpContext<?> httpContext, @Advice.FieldValue(value="clientRequest") HttpClientRequest request) {
                webClientHelper.followRedirect(httpContext, request);
            }
        }
    }

    public static class HttpContextFailInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("fail").and(ElementMatchers.takesArgument(0, Throwable.class));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.webclient.WebClientInstrumentation$HttpContextFailInstrumentation$HttpContextFailAdvice";
        }

        public static class HttpContextFailAdvice
        extends AdviceBase {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void fail(@Advice.This HttpContext<?> httpContext, @Advice.Argument(value=0) Throwable thrown) {
                webClientHelper.failSpan(httpContext, thrown, null);
            }
        }
    }

    public static class HttpContextDispatchResponseInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("dispatchResponse").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.ext.web.client.HttpResponse")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.webclient.WebClientInstrumentation$HttpContextDispatchResponseInstrumentation$HttpContextDispatchResponseAdvice";
        }

        public static class HttpContextDispatchResponseAdvice
        extends AdviceBase {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void receiveResponse(@Advice.This HttpContext<?> httpContext, @Advice.Argument(value=0) HttpResponse<?> response) {
                webClientHelper.endSpan(httpContext, response);
            }
        }
    }

    public static class HttpContextSendRequestInstrumentation
    extends HttpContextInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("sendRequest").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.http.HttpClientRequest")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.webclient.WebClientInstrumentation$HttpContextSendRequestInstrumentation$HttpContextSendRequestAdvice";
        }

        public static class HttpContextSendRequestAdvice
        extends AdviceBase {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void sendRequest(@Advice.This HttpContext<?> httpContext, @Advice.Argument(value=0) HttpClientRequest request, @Advice.FieldValue(value="context") Context vertxContext) {
                AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
                if (null != parent) {
                    webClientHelper.startSpan(parent, httpContext, request);
                } else {
                    webClientHelper.followRedirect(httpContext, request);
                }
            }
        }
    }

    public static class AdviceBase {
        protected static final AbstractVertxWebClientHelper webClientHelper = new AbstractVertxWebClientHelper(){

            @Override
            protected String getMethod(HttpClientRequest request) {
                return request.method().name();
            }
        };
    }

    public static abstract class HttpContextInstrumentation
    extends WebClientInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("io.vertx.ext.web.client.impl.HttpContext");
        }
    }
}

