/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web.http2;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import co.elastic.apm.agent.vertx.v3.web.WebInstrumentation;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.Http2ServerRequestImpl;
import io.vertx.core.http.impl.Http2ServerResponseImpl;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Http2ServerRequestImplEndInstrumentation
extends WebInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.core.http.impl.Http2ServerRequestImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handleEnd");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.vertx.v3.web.http2.Http2ServerRequestImplEndInstrumentation$HttpRequestEndAdvice";
    }

    public static class HttpRequestEndAdvice {
        private static final Logger log = LoggerFactory.getLogger(HttpRequestEndAdvice.class);
        private static final WebHelper helper = WebHelper.getInstance();

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void exit(@Advice.This Http2ServerRequestImpl request, @Advice.FieldValue(value="response") @Nullable Http2ServerResponseImpl response) {
            Transaction transaction = helper.removeTransactionMapping(request);
            if (transaction != null) {
                helper.finalizeTransaction((HttpServerResponse)response, transaction);
                log.debug("VERTX-DEBUG: ended Vert.x HTTP 2 transaction {} with details from this response: {}", (Object)transaction, (Object)response);
            } else {
                log.debug("VERTX-DEBUG: could not find a transaction for the following Vert.x HTTP 2 request: {}", (Object)request);
            }
        }
    }
}

