/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web.http1;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import co.elastic.apm.agent.vertx.v3.web.WebInstrumentation;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.HttpServerRequestImpl;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Http1StartTransactionInstrumentation
extends WebInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.core.http.impl.HttpServerRequestImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handleBegin").and(ElementMatchers.takesNoArguments());
    }

    public static class AdviceClass {
        private static final Logger log = LoggerFactory.getLogger(AdviceClass.class);
        private static final WebHelper helper = WebHelper.getInstance();

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object enter(@Advice.This HttpServerRequestImpl request) {
            Transaction transaction = helper.startOrGetTransaction((HttpServerRequest)request);
            if (transaction != null) {
                transaction.activate();
            }
            log.debug("VERTX-DEBUG: started Vert.x 3.x HTTP 1 transaction: {}", (Object)transaction);
            return transaction;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void exit(@Advice.Enter Object transactionObj, @Advice.Thrown @Nullable Throwable thrown) {
            if (transactionObj instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObj;
                ((Transaction)transaction.captureException(thrown)).deactivate();
            }
        }
    }
}

