/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web.http1;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import co.elastic.apm.agent.vertx.v3.web.WebInstrumentation;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpServerRequestImpl;
import io.vertx.core.http.impl.HttpServerResponseImpl;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Http1EndTransactionInstrumentation
extends WebInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.core.http.impl.Http1xServerConnection");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("responseComplete").and(ElementMatchers.takesNoArguments());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.vertx.v3.web.http1.Http1EndTransactionInstrumentation$ResponseCompleteAdvice";
    }

    public static class ResponseCompleteAdvice {
        private static final Logger log = LoggerFactory.getLogger(ResponseCompleteAdvice.class);
        private static final WebHelper helper = WebHelper.getInstance();

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void exit(@Advice.FieldValue(value="responseInProgress") HttpServerRequestImpl responseInProgress) {
            Transaction transaction = helper.removeTransactionMapping(responseInProgress);
            if (transaction != null) {
                HttpServerResponseImpl response = responseInProgress.response();
                if (response != null) {
                    helper.finalizeTransaction((HttpServerResponse)response, transaction);
                    log.debug("VERTX-DEBUG: ended Vert.x HTTP 1 transaction {} with details from this response: {}", (Object)transaction, (Object)response);
                } else {
                    log.debug("VERTX-DEBUG: response is not yet set for the following Vert.x HTTP 1 request: {}", (Object)responseInProgress);
                }
            } else {
                log.debug("VERTX-DEBUG: could not find a transaction for the following Vert.x HTTP 1 request: {}", (Object)responseInProgress);
            }
        }
    }
}

