/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web;

import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.vertx.AbstractVertxWebHelper;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import javax.annotation.Nullable;

public class WebHelper
extends AbstractVertxWebHelper {
    private static final Logger log = LoggerFactory.getLogger(WebHelper.class);
    private static final WebHelper INSTANCE = new WebHelper(GlobalTracer.requireTracerImpl());
    static final WeakMap<Object, Transaction> transactionMap = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final NoopHandler noopHandler = new NoopHandler();

    public static WebHelper getInstance() {
        return INSTANCE;
    }

    WebHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    @Nullable
    public Transaction startOrGetTransaction(HttpServerRequest httpServerRequest) {
        Transaction transaction = super.startOrGetTransaction(httpServerRequest);
        if (transaction != null) {
            this.mapTransaction(httpServerRequest, transaction);
            this.enrichRequest(httpServerRequest, transaction);
        }
        return transaction;
    }

    @Override
    public Transaction setRouteBasedNameForCurrentTransaction(RoutingContext routingContext) {
        HttpServerRequest request = routingContext.request();
        Transaction transaction = this.getTransactionForRequest(request);
        if (transaction != null) {
            this.setRouteBasedTransactionName(transaction, routingContext);
        }
        return transaction;
    }

    public void mapTransaction(Object key, Transaction transaction) {
        transactionMap.put(key, transaction);
    }

    @Nullable
    public Transaction lookupTransaction(Object key) {
        return transactionMap.get(key);
    }

    @Nullable
    public Transaction removeTransactionMapping(Object key) {
        return transactionMap.remove(key);
    }

    @Nullable
    public Transaction getTransactionForRequest(HttpServerRequest request) {
        Transaction transaction;
        if (request.getClass().getName().equals("io.vertx.ext.web.impl.HttpServerRequestWrapper")) {
            request = request.endHandler((Handler)this.noopHandler);
            log.debug("VERTX-DEBUG: Vert.x request obtained through endHandler instrumentation: {}", (Object)request);
        }
        if ((transaction = this.lookupTransaction(request)) != null) {
            log.debug("VERTX-DEBUG: transaction {} is mapped to the Vert.x request: {}", (Object)transaction, (Object)request);
        } else {
            transaction = this.lookupTransaction(request.response());
        }
        return transaction;
    }

    public static class NoopHandler
    implements Handler<Void> {
        public void handle(Void event) {
        }
    }
}

