/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3;

import co.elastic.apm.agent.vertx.GenericHandlerWrapper;
import co.elastic.apm.agent.vertx.SetTimerWrapper;
import co.elastic.apm.agent.vertx.v3.Vertx3Instrumentation;
import io.vertx.core.Handler;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class EventLoopInstrumentation
extends Vertx3Instrumentation {

    public static class ExecuteOnContextAdvice {
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Handler<?> executeBlockingEnter(@Advice.Argument(value=0) Handler<?> handler) {
            return GenericHandlerWrapper.wrapIfActiveSpan(handler);
        }
    }

    public static class ExecuteBlockingInstrumentation
    extends EventLoopInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("io.vertx.core.impl.ContextImpl");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("executeBlocking").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.Handler"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("io.vertx.core.Handler"))).and(ElementMatchers.isPackagePrivate());
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.EventLoopInstrumentation$ExecuteOnContextAdvice";
        }
    }

    public static class OnContextInstrumentation
    extends EventLoopInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("io.vertx.core.impl.ContextImpl");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("runOnContext").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.vertx.core.Handler")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.EventLoopInstrumentation$ExecuteOnContextAdvice";
        }
    }

    public static class SetTimerInstrumentation
    extends EventLoopInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("io.vertx.core.impl.VertxImpl");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("setTimer").and(ElementMatchers.takesArgument(1, ElementMatchers.named("io.vertx.core.Handler")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.EventLoopInstrumentation$SetTimerInstrumentation$SetTimerAdvice";
        }

        public static class SetTimerAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=1)})
            public static Handler<Long> setTimerEnter(@Advice.Argument(value=1) Handler<Long> handler) {
                return SetTimerWrapper.wrapTimerIfActiveSpan(handler);
            }
        }
    }
}

