/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.vertx.GenericHandlerWrapper;
import io.vertx.core.Handler;

public class SetTimerWrapper
extends GenericHandlerWrapper<Long> {
    private static final ThreadLocal<String> activeTimerHandlerPerThread = new ThreadLocal();

    @Override
    public void handle(Long event) {
        activeTimerHandlerPerThread.set(this.actualHandler.getClass().getName());
        try {
            super.handle(event);
        }
        finally {
            activeTimerHandlerPerThread.remove();
        }
    }

    public SetTimerWrapper(AbstractSpan<?> parentSpan, Handler<Long> actualHandler) {
        super(parentSpan, actualHandler);
    }

    public static Handler<Long> wrapTimerIfActiveSpan(Handler<Long> handler) {
        AbstractSpan<?> currentSpan = GlobalTracer.get().getActive();
        if (currentSpan != null && !handler.getClass().getName().equals(activeTimerHandlerPerThread.get())) {
            handler = new SetTimerWrapper(currentSpan, handler);
        }
        return handler;
    }
}

