/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import co.elastic.apm.agent.util.VersionUtils;
import co.elastic.apm.agent.vertx.AbstractHttpTransactionHelper;
import co.elastic.apm.agent.vertx.MultiMapHeadersGetterSetter;
import co.elastic.apm.agent.vertx.NettyByteTransfer;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractVertxWebHelper
extends AbstractHttpTransactionHelper {
    private final Logger logger = LoggerFactory.getLogger(AbstractVertxWebHelper.class);
    public static final String CONTEXT_TRANSACTION_KEY = AbstractVertxWebHelper.class.getName() + ".transaction";
    public static final String FRAMEWORK_NAME = "Vert.x-Web";
    private static final String SPAN_TYPE = "request";
    private final MultiMapHeadersGetterSetter headerGetter = new MultiMapHeadersGetterSetter();

    protected AbstractVertxWebHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Nullable
    protected Transaction startOrGetTransaction(HttpServerRequest httpServerRequest) {
        Transaction transaction = this.tracer.currentTransaction();
        if (transaction != null) {
            return transaction;
        }
        if (!this.serverHelper.isRequestExcluded(httpServerRequest.uri(), httpServerRequest.headers().get("User-Agent"))) {
            transaction = this.tracer.startChildTransaction(httpServerRequest.headers(), this.headerGetter, PrivilegedActionUtils.getClassLoader(httpServerRequest.getClass()));
        }
        return transaction;
    }

    @Nullable
    public abstract Transaction setRouteBasedNameForCurrentTransaction(RoutingContext var1);

    protected void setRouteBasedTransactionName(Transaction transaction, RoutingContext routingContext) {
        StringBuilder transactionName;
        String path;
        if (!this.webConfiguration.isUsePathAsName() && (path = routingContext.currentRoute().getPath()) != null && (transactionName = transaction.getAndOverrideName(100)) != null) {
            transactionName.append(routingContext.request().method().name()).append(" ").append(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeTransaction(@Nullable HttpServerResponse httpServerResponse, Transaction transaction) {
        try {
            if (httpServerResponse != null) {
                Response response = transaction.getContext().getResponse();
                int status = httpServerResponse.getStatusCode();
                this.setResponseHeaders(transaction, httpServerResponse, response);
                this.fillResponse(response, null, status);
                transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(status));
            }
        }
        catch (Throwable e) {
            this.logger.warn("Exception while capturing Elastic APM transaction", e);
        }
        finally {
            transaction.end();
        }
    }

    public void captureBody(@Nullable Transaction transaction, Buffer requestDataBuffer) {
        if (transaction == null || transaction.getContext().getRequest().getBodyBuffer() == null) {
            return;
        }
        Request request = transaction.getContext().getRequest();
        CharBuffer bodyBuffer = request.getBodyBuffer();
        ByteBuf buffer = requestDataBuffer.getByteBuf().duplicate();
        CoderResult coderResult = NettyByteTransfer.decodeUtf8BytesFromTransfer(buffer, bodyBuffer);
        if (coderResult.isError()) {
            request.setRawBody("[Non UTF-8 data]");
        } else if (coderResult.isOverflow()) {
            request.endOfBufferInput();
        }
    }

    protected void enrichRequest(HttpServerRequest httpServerRequest, Transaction transaction) {
        transaction.setFrameworkName(FRAMEWORK_NAME);
        transaction.setFrameworkVersion(VersionUtils.getVersion(HttpServerRequest.class, "io.vertx", "vertx-web"));
        transaction.withType(SPAN_TYPE);
        Request request = transaction.getContext().getRequest();
        String host = httpServerRequest.host();
        int idx = host.lastIndexOf(58);
        if (idx > 0) {
            host = host.substring(0, idx);
        }
        String method = httpServerRequest.method().name();
        String contentType = httpServerRequest.headers().get("Content-Type");
        this.fillRequest(request, httpServerRequest.version().toString(), method, httpServerRequest.scheme(), host, httpServerRequest.connection().localAddress().port(), httpServerRequest.path(), httpServerRequest.query(), httpServerRequest.remoteAddress().toString());
        this.applyDefaultTransactionName(httpServerRequest.method().name(), httpServerRequest.path(), null, transaction, 10);
        this.startCaptureBody(transaction, method, contentType);
        this.setRequestHeaders(transaction, httpServerRequest);
        this.setRequestParameters(transaction, httpServerRequest, method, contentType);
    }

    private void setResponseHeaders(Transaction transaction, HttpServerResponse httpServerResponse, Response response) {
        Set headerNames;
        if (transaction.isSampled() && this.isCaptureHeaders() && (headerNames = httpServerResponse.headers().names()) != null) {
            for (String headerName : headerNames) {
                response.addHeader(headerName, httpServerResponse.headers().getAll(headerName));
            }
        }
    }

    private void setRequestParameters(Transaction transaction, HttpServerRequest httpServerRequest, String method, String contentType) {
        if (transaction.isSampled() && this.captureParameters(method, contentType)) {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            for (String name : httpServerRequest.params().names()) {
                List allValues = httpServerRequest.params().getAll(name);
                String[] paramValues = new String[allValues.size()];
                allValues.toArray(paramValues);
                parameterMap.put(name, paramValues);
            }
            this.fillRequestParameters(transaction, method, parameterMap, contentType);
        }
    }

    private void setRequestHeaders(Transaction transaction, HttpServerRequest httpServerRequest) {
        Request req = transaction.getContext().getRequest();
        if (transaction.isSampled() && this.isCaptureHeaders()) {
            this.setCookies(httpServerRequest, req);
            Set headerNames = httpServerRequest.headers().names();
            if (headerNames != null) {
                for (String headerName : headerNames) {
                    Enumeration<String> headers = Collections.enumeration(httpServerRequest.headers().getAll(headerName));
                    req.addHeader(headerName, headers);
                }
            }
        }
    }

    private void setCookies(HttpServerRequest httpServerRequest, Request request) {
        String cookieString = httpServerRequest.headers().get(HttpHeaders.COOKIE);
        if (cookieString != null) {
            for (Cookie cookie : ServerCookieDecoder.LAX.decode(cookieString)) {
                request.addCookie(cookie.name(), cookie.value());
            }
        }
    }
}

