/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarInputStream;
import javax.annotation.Nullable;

public final class VersionUtils {
    private static final WeakMap<Class<?>, String> versionsCache;
    private static final String UNKNOWN_VERSION = "UNKNOWN_VERSION";
    @Nullable
    private static final String AGENT_VERSION;

    private VersionUtils() {
    }

    public static String getAgentVersion() {
        return AGENT_VERSION != null ? AGENT_VERSION : "unknown";
    }

    @Nullable
    public static String getVersion(Class<?> clazz, String groupId, String artifactId) {
        String version = versionsCache.get(clazz);
        if (version != null) {
            return version != UNKNOWN_VERSION ? version : null;
        }
        version = VersionUtils.getVersionFromPomProperties(clazz, groupId, artifactId);
        if (version == null) {
            version = VersionUtils.getVersionFromPackage(clazz);
        }
        versionsCache.put(clazz, version != null ? version : UNKNOWN_VERSION);
        return version;
    }

    @Nullable
    static String getVersionFromPackage(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            return pkg.getImplementationVersion();
        }
        return null;
    }

    @Nullable
    static String getVersionFromPomProperties(Class<?> clazz, String groupId, String artifactId) {
        String classpathLocation = "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        Properties pomProperties = VersionUtils.getFromClasspath(classpathLocation, clazz);
        if (pomProperties != null) {
            return pomProperties.getProperty("version");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Properties getFromClasspath(String classpathLocation, Class<?> clazz) {
        Properties props = new Properties();
        try (InputStream resourceStream = clazz.getResourceAsStream(classpathLocation);){
            if (resourceStream == null) return null;
            props.load(resourceStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static String getManifestEntry(@Nullable File jarFile, String manifestAttribute) {
        String string;
        if (jarFile == null) {
            return null;
        }
        JarInputStream jarInputStream = new JarInputStream(PrivilegedActionUtils.newFileInputStream(jarFile));
        try {
            string = jarInputStream.getManifest().getMainAttributes().getValue(manifestAttribute);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        jarInputStream.close();
        return string;
    }

    static {
        String gitRev;
        versionsCache = WeakConcurrent.buildMap();
        File agentJar = ElasticApmAgent.getAgentJarFile();
        String version = VersionUtils.getManifestEntry(agentJar, "Implementation-Version");
        if (version != null && version.endsWith("SNAPSHOT") && (gitRev = VersionUtils.getManifestEntry(agentJar, "SCM-Revision")) != null) {
            version = version + "." + gitRev;
        }
        AGENT_VERSION = version;
    }
}

