/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.util.GlobalLocks;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConnectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(UrlConnectionUtils.class);

    public static URLConnection openUrlConnectionThreadSafely(URL url) throws IOException {
        GlobalLocks.JUL_INIT_LOCK.lock();
        try {
            if (logger.isDebugEnabled()) {
                UrlConnectionUtils.debugPrintProxySettings(url);
            }
            URLConnection uRLConnection = url.openConnection();
            return uRLConnection;
        }
        finally {
            GlobalLocks.JUL_INIT_LOCK.unlock();
        }
    }

    private static void debugPrintProxySettings(URL url) {
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null || proxySelector.getClass().getName().equals("sun.net.spi.DefaultProxySelector")) {
            String proxyHostProperty = url.getProtocol() + ".proxyHost";
            String proxyPortProperty = url.getProtocol() + ".proxyPort";
            String proxyHost = System.getProperty(proxyHostProperty);
            String proxyPort = System.getProperty(proxyPortProperty);
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            if (proxyHost == null || proxyHost.isEmpty()) {
                logger.debug("Opening {} without proxy", (Object)url);
            } else {
                logger.debug("Opening {} with proxy settings: {}={}, {}={}, http.nonProxyHosts={}", url, proxyHostProperty, proxyHost, proxyPortProperty, proxyPort, nonProxyHosts);
            }
        } else {
            try {
                List<Proxy> proxies = proxySelector.select(url.toURI());
                String proxySelectorName = proxySelector.getClass().getName();
                if (proxies != null && proxies.size() == 1 && proxies.get(0).equals(Proxy.NO_PROXY)) {
                    logger.debug("Opening {} without proxy (ProxySelector {})", (Object)url, (Object)proxySelectorName);
                } else {
                    logger.debug("Opening {} with proxies {} (ProxySelector {})", url, proxies, proxySelectorName);
                }
            }
            catch (URISyntaxException e) {
                logger.debug("Failed to read and debug-print proxy settings for {}", (Object)url, (Object)e);
            }
        }
    }
}

