/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.matcher.WildcardMatcher;
import java.util.List;
import javax.annotation.Nullable;

public class TransactionNameUtils {
    public static void setTransactionNameByServletClass(@Nullable String httpMethod, @Nullable Class<?> servletClass, @Nullable StringBuilder transactionName) {
        if (servletClass == null || transactionName == null) {
            return;
        }
        String servletClassName = servletClass.getName();
        transactionName.append(servletClassName, servletClassName.lastIndexOf(46) + 1, servletClassName.length());
        if (httpMethod == null) {
            return;
        }
        transactionName.append('#');
        switch (httpMethod) {
            case "DELETE": {
                transactionName.append("doDelete");
                break;
            }
            case "HEAD": {
                transactionName.append("doHead");
                break;
            }
            case "GET": {
                transactionName.append("doGet");
                break;
            }
            case "OPTIONS": {
                transactionName.append("doOptions");
                break;
            }
            case "POST": {
                transactionName.append("doPost");
                break;
            }
            case "PUT": {
                transactionName.append("doPut");
                break;
            }
            case "TRACE": {
                transactionName.append("doTrace");
                break;
            }
            default: {
                transactionName.append(httpMethod);
            }
        }
    }

    public static void setNameFromClassAndMethod(String className, @Nullable String methodName, @Nullable StringBuilder transactionName) {
        if (transactionName == null) {
            return;
        }
        transactionName.append(className);
        if (methodName != null) {
            transactionName.append('#').append(methodName);
        }
    }

    public static void setNameFromHttpRequestPath(String method, String path, @Nullable StringBuilder transactionName, List<WildcardMatcher> urlGroups) {
        TransactionNameUtils.setNameFromHttpRequestPath(method, path, null, transactionName, urlGroups);
    }

    public static void setNameFromHttpRequestPath(String method, String pathFirstPart, @Nullable String pathSecondPart, @Nullable StringBuilder transactionName, List<WildcardMatcher> urlGroups) {
        if (transactionName == null) {
            return;
        }
        WildcardMatcher groupMatcher = WildcardMatcher.anyMatch(urlGroups, pathFirstPart, pathSecondPart);
        if (groupMatcher != null) {
            transactionName.append(method).append(' ').append(groupMatcher);
        } else {
            transactionName.append(method).append(' ').append(pathFirstPart);
            if (pathSecondPart != null) {
                transactionName.append(pathSecondPart);
            }
        }
    }

    public static void setNameUnknownRoute(String method, @Nullable StringBuilder transactionName) {
        if (transactionName == null) {
            return;
        }
        transactionName.append(method).append(' ').append("unknown route");
    }
}

